/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.email.model.UpdateDkimDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDkimRequest
extends BmcRequest<UpdateDkimDetails> {
    private String dkimId;
    private UpdateDkimDetails updateDkimDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDkimId() {
        return this.dkimId;
    }

    public UpdateDkimDetails getUpdateDkimDetails() {
        return this.updateDkimDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateDkimDetails getBody$() {
        return this.updateDkimDetails;
    }

    public Builder toBuilder() {
        return new Builder().dkimId(this.dkimId).updateDkimDetails(this.updateDkimDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dkimId=").append(String.valueOf(this.dkimId));
        sb.append(",updateDkimDetails=").append(String.valueOf((Object)this.updateDkimDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDkimRequest)) {
            return false;
        }
        UpdateDkimRequest other = (UpdateDkimRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dkimId, other.dkimId) && Objects.equals((Object)this.updateDkimDetails, (Object)other.updateDkimDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dkimId == null ? 43 : this.dkimId.hashCode());
        result = result * 59 + (this.updateDkimDetails == null ? 43 : this.updateDkimDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDkimRequest, UpdateDkimDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dkimId = null;
        private UpdateDkimDetails updateDkimDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder dkimId(String dkimId) {
            this.dkimId = dkimId;
            return this;
        }

        public Builder updateDkimDetails(UpdateDkimDetails updateDkimDetails) {
            this.updateDkimDetails = updateDkimDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDkimRequest o) {
            this.dkimId(o.getDkimId());
            this.updateDkimDetails(o.getUpdateDkimDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDkimRequest build() {
            UpdateDkimRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDkimDetails body) {
            this.updateDkimDetails(body);
            return this;
        }

        public UpdateDkimRequest buildWithoutInvocationCallback() {
            UpdateDkimRequest request = new UpdateDkimRequest();
            request.dkimId = this.dkimId;
            request.updateDkimDetails = this.updateDkimDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

