/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.oracle.bmc.email.Email;
import com.oracle.bmc.email.model.Dkim;
import com.oracle.bmc.email.model.EmailDomain;
import com.oracle.bmc.email.model.Sender;
import com.oracle.bmc.email.requests.GetDkimRequest;
import com.oracle.bmc.email.requests.GetEmailDomainRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetWorkRequestRequest;
import com.oracle.bmc.email.responses.GetDkimResponse;
import com.oracle.bmc.email.responses.GetEmailDomainResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class EmailWaiters {
    private final ExecutorService executorService;
    private final Email client;

    public EmailWaiters(ExecutorService executorService, Email client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDkimRequest, GetDkimResponse> forDkim(GetDkimRequest request, Dkim.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDkim(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDkimRequest, GetDkimResponse> forDkim(GetDkimRequest request, Dkim.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDkim(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDkimRequest, GetDkimResponse> forDkim(GetDkimRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Dkim.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDkim(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDkimRequest, GetDkimResponse> forDkim(BmcGenericWaiter waiter, GetDkimRequest request, Dkim.LifecycleState ... targetStates) {
        final HashSet<Dkim.LifecycleState> targetStatesSet = new HashSet<Dkim.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDkimRequest, GetDkimResponse>(){

            @Override
            public GetDkimResponse apply(GetDkimRequest request) {
                return EmailWaiters.this.client.getDkim(request);
            }
        }, (Predicate)new Predicate<GetDkimResponse>(){

            @Override
            public boolean test(GetDkimResponse response) {
                return targetStatesSet.contains((Object)response.getDkim().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Dkim.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEmailDomainRequest, GetEmailDomainResponse> forEmailDomain(GetEmailDomainRequest request, EmailDomain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEmailDomain(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEmailDomainRequest, GetEmailDomainResponse> forEmailDomain(GetEmailDomainRequest request, EmailDomain.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEmailDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEmailDomainRequest, GetEmailDomainResponse> forEmailDomain(GetEmailDomainRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, EmailDomain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEmailDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEmailDomainRequest, GetEmailDomainResponse> forEmailDomain(BmcGenericWaiter waiter, GetEmailDomainRequest request, EmailDomain.LifecycleState ... targetStates) {
        final HashSet<EmailDomain.LifecycleState> targetStatesSet = new HashSet<EmailDomain.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEmailDomainRequest, GetEmailDomainResponse>(){

            @Override
            public GetEmailDomainResponse apply(GetEmailDomainRequest request) {
                return EmailWaiters.this.client.getEmailDomain(request);
            }
        }, (Predicate)new Predicate<GetEmailDomainResponse>(){

            @Override
            public boolean test(GetEmailDomainResponse response) {
                return targetStatesSet.contains((Object)response.getEmailDomain().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)EmailDomain.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, Sender.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSender(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, Sender.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSender(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSenderRequest, GetSenderResponse> forSender(GetSenderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Sender.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSender(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSenderRequest, GetSenderResponse> forSender(BmcGenericWaiter waiter, GetSenderRequest request, Sender.LifecycleState ... targetStates) {
        final HashSet<Sender.LifecycleState> targetStatesSet = new HashSet<Sender.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSenderRequest, GetSenderResponse>(){

            @Override
            public GetSenderResponse apply(GetSenderRequest request) {
                return EmailWaiters.this.client.getSender(request);
            }
        }, (Predicate)new Predicate<GetSenderResponse>(){

            @Override
            public boolean test(GetSenderResponse response) {
                return targetStatesSet.contains((Object)response.getSender().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Sender.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return EmailWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

