/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.UpdateTransferJobDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTransferJobRequest
extends BmcRequest<UpdateTransferJobDetails> {
    private String id;
    private UpdateTransferJobDetails updateTransferJobDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getId() {
        return this.id;
    }

    public UpdateTransferJobDetails getUpdateTransferJobDetails() {
        return this.updateTransferJobDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateTransferJobDetails getBody$() {
        return this.updateTransferJobDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).updateTransferJobDetails(this.updateTransferJobDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",updateTransferJobDetails=").append(String.valueOf((Object)this.updateTransferJobDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTransferJobRequest)) {
            return false;
        }
        UpdateTransferJobRequest other = (UpdateTransferJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.updateTransferJobDetails, (Object)other.updateTransferJobDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.updateTransferJobDetails == null ? 43 : this.updateTransferJobDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTransferJobRequest, UpdateTransferJobDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private UpdateTransferJobDetails updateTransferJobDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder updateTransferJobDetails(UpdateTransferJobDetails updateTransferJobDetails) {
            this.updateTransferJobDetails = updateTransferJobDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTransferJobRequest o) {
            this.id(o.getId());
            this.updateTransferJobDetails(o.getUpdateTransferJobDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTransferJobRequest build() {
            UpdateTransferJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTransferJobDetails body) {
            this.updateTransferJobDetails(body);
            return this;
        }

        public UpdateTransferJobRequest buildWithoutInvocationCallback() {
            UpdateTransferJobRequest request = new UpdateTransferJobRequest();
            request.id = this.id;
            request.updateTransferJobDetails = this.updateTransferJobDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

