/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetApplianceExportJobRequest
extends BmcRequest<Void> {
    private String applianceExportJobId;
    private String opcRequestId;

    public String getApplianceExportJobId() {
        return this.applianceExportJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().applianceExportJobId(this.applianceExportJobId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",applianceExportJobId=").append(String.valueOf(this.applianceExportJobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetApplianceExportJobRequest)) {
            return false;
        }
        GetApplianceExportJobRequest other = (GetApplianceExportJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.applianceExportJobId, other.applianceExportJobId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.applianceExportJobId == null ? 43 : this.applianceExportJobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetApplianceExportJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String applianceExportJobId = null;
        private String opcRequestId = null;

        public Builder applianceExportJobId(String applianceExportJobId) {
            this.applianceExportJobId = applianceExportJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetApplianceExportJobRequest o) {
            this.applianceExportJobId(o.getApplianceExportJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetApplianceExportJobRequest build() {
            GetApplianceExportJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetApplianceExportJobRequest buildWithoutInvocationCallback() {
            GetApplianceExportJobRequest request = new GetApplianceExportJobRequest();
            request.applianceExportJobId = this.applianceExportJobId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

