/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.DetachDevicesDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetachDevicesFromTransferPackageRequest
extends BmcRequest<DetachDevicesDetails> {
    private String id;
    private String transferPackageLabel;
    private DetachDevicesDetails detachDevicesDetails;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public DetachDevicesDetails getDetachDevicesDetails() {
        return this.detachDevicesDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public DetachDevicesDetails getBody$() {
        return this.detachDevicesDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).transferPackageLabel(this.transferPackageLabel).detachDevicesDetails(this.detachDevicesDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",transferPackageLabel=").append(String.valueOf(this.transferPackageLabel));
        sb.append(",detachDevicesDetails=").append(String.valueOf((Object)this.detachDevicesDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetachDevicesFromTransferPackageRequest)) {
            return false;
        }
        DetachDevicesFromTransferPackageRequest other = (DetachDevicesFromTransferPackageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.transferPackageLabel, other.transferPackageLabel) && Objects.equals((Object)this.detachDevicesDetails, (Object)other.detachDevicesDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.transferPackageLabel == null ? 43 : this.transferPackageLabel.hashCode());
        result = result * 59 + (this.detachDevicesDetails == null ? 43 : this.detachDevicesDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetachDevicesFromTransferPackageRequest, DetachDevicesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String transferPackageLabel = null;
        private DetachDevicesDetails detachDevicesDetails = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public Builder detachDevicesDetails(DetachDevicesDetails detachDevicesDetails) {
            this.detachDevicesDetails = detachDevicesDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachDevicesFromTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.detachDevicesDetails(o.getDetachDevicesDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachDevicesFromTransferPackageRequest build() {
            DetachDevicesFromTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DetachDevicesDetails body) {
            this.detachDevicesDetails(body);
            return this;
        }

        public DetachDevicesFromTransferPackageRequest buildWithoutInvocationCallback() {
            DetachDevicesFromTransferPackageRequest request = new DetachDevicesFromTransferPackageRequest();
            request.id = this.id;
            request.transferPackageLabel = this.transferPackageLabel;
            request.detachDevicesDetails = this.detachDevicesDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

