/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dts.model.ShippingAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateTransferApplianceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="expectedReturnDate")
    private final Date expectedReturnDate;
    @JsonProperty(value="pickupWindowStartTime")
    private final Date pickupWindowStartTime;
    @JsonProperty(value="pickupWindowEndTime")
    private final Date pickupWindowEndTime;
    @JsonProperty(value="minimumStorageCapacityInTerabytes")
    private final Integer minimumStorageCapacityInTerabytes;

    @Deprecated
    @ConstructorProperties(value={"lifecycleState", "customerShippingAddress", "expectedReturnDate", "pickupWindowStartTime", "pickupWindowEndTime", "minimumStorageCapacityInTerabytes"})
    public UpdateTransferApplianceDetails(LifecycleState lifecycleState, ShippingAddress customerShippingAddress, Date expectedReturnDate, Date pickupWindowStartTime, Date pickupWindowEndTime, Integer minimumStorageCapacityInTerabytes) {
        this.lifecycleState = lifecycleState;
        this.customerShippingAddress = customerShippingAddress;
        this.expectedReturnDate = expectedReturnDate;
        this.pickupWindowStartTime = pickupWindowStartTime;
        this.pickupWindowEndTime = pickupWindowEndTime;
        this.minimumStorageCapacityInTerabytes = minimumStorageCapacityInTerabytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public Date getPickupWindowStartTime() {
        return this.pickupWindowStartTime;
    }

    public Date getPickupWindowEndTime() {
        return this.pickupWindowEndTime;
    }

    public Integer getMinimumStorageCapacityInTerabytes() {
        return this.minimumStorageCapacityInTerabytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateTransferApplianceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", customerShippingAddress=").append(String.valueOf((Object)this.customerShippingAddress));
        sb.append(", expectedReturnDate=").append(String.valueOf(this.expectedReturnDate));
        sb.append(", pickupWindowStartTime=").append(String.valueOf(this.pickupWindowStartTime));
        sb.append(", pickupWindowEndTime=").append(String.valueOf(this.pickupWindowEndTime));
        sb.append(", minimumStorageCapacityInTerabytes=").append(String.valueOf(this.minimumStorageCapacityInTerabytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTransferApplianceDetails)) {
            return false;
        }
        UpdateTransferApplianceDetails other = (UpdateTransferApplianceDetails)((Object)o);
        return Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.customerShippingAddress, (Object)other.customerShippingAddress) && Objects.equals(this.expectedReturnDate, other.expectedReturnDate) && Objects.equals(this.pickupWindowStartTime, other.pickupWindowStartTime) && Objects.equals(this.pickupWindowEndTime, other.pickupWindowEndTime) && Objects.equals(this.minimumStorageCapacityInTerabytes, other.minimumStorageCapacityInTerabytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.customerShippingAddress == null ? 43 : this.customerShippingAddress.hashCode());
        result = result * 59 + (this.expectedReturnDate == null ? 43 : this.expectedReturnDate.hashCode());
        result = result * 59 + (this.pickupWindowStartTime == null ? 43 : this.pickupWindowStartTime.hashCode());
        result = result * 59 + (this.pickupWindowEndTime == null ? 43 : this.pickupWindowEndTime.hashCode());
        result = result * 59 + (this.minimumStorageCapacityInTerabytes == null ? 43 : this.minimumStorageCapacityInTerabytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Preparing("PREPARING"),
        Finalized("FINALIZED"),
        ReturnLabelRequested("RETURN_LABEL_REQUESTED"),
        ReturnLabelGenerating("RETURN_LABEL_GENERATING"),
        ReturnLabelAvailable("RETURN_LABEL_AVAILABLE"),
        Deleted("DELETED"),
        CustomerNeverReceived("CUSTOMER_NEVER_RECEIVED"),
        Cancelled("CANCELLED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="expectedReturnDate")
        private Date expectedReturnDate;
        @JsonProperty(value="pickupWindowStartTime")
        private Date pickupWindowStartTime;
        @JsonProperty(value="pickupWindowEndTime")
        private Date pickupWindowEndTime;
        @JsonProperty(value="minimumStorageCapacityInTerabytes")
        private Integer minimumStorageCapacityInTerabytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder expectedReturnDate(Date expectedReturnDate) {
            this.expectedReturnDate = expectedReturnDate;
            this.__explicitlySet__.add("expectedReturnDate");
            return this;
        }

        public Builder pickupWindowStartTime(Date pickupWindowStartTime) {
            this.pickupWindowStartTime = pickupWindowStartTime;
            this.__explicitlySet__.add("pickupWindowStartTime");
            return this;
        }

        public Builder pickupWindowEndTime(Date pickupWindowEndTime) {
            this.pickupWindowEndTime = pickupWindowEndTime;
            this.__explicitlySet__.add("pickupWindowEndTime");
            return this;
        }

        public Builder minimumStorageCapacityInTerabytes(Integer minimumStorageCapacityInTerabytes) {
            this.minimumStorageCapacityInTerabytes = minimumStorageCapacityInTerabytes;
            this.__explicitlySet__.add("minimumStorageCapacityInTerabytes");
            return this;
        }

        public UpdateTransferApplianceDetails build() {
            UpdateTransferApplianceDetails model = new UpdateTransferApplianceDetails(this.lifecycleState, this.customerShippingAddress, this.expectedReturnDate, this.pickupWindowStartTime, this.pickupWindowEndTime, this.minimumStorageCapacityInTerabytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateTransferApplianceDetails model) {
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("customerShippingAddress")) {
                this.customerShippingAddress(model.getCustomerShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("expectedReturnDate")) {
                this.expectedReturnDate(model.getExpectedReturnDate());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowStartTime")) {
                this.pickupWindowStartTime(model.getPickupWindowStartTime());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowEndTime")) {
                this.pickupWindowEndTime(model.getPickupWindowEndTime());
            }
            if (model.wasPropertyExplicitlySet("minimumStorageCapacityInTerabytes")) {
                this.minimumStorageCapacityInTerabytes(model.getMinimumStorageCapacityInTerabytes());
            }
            return this;
        }
    }
}

