/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TransferDeviceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="iscsiIQN")
    private final String iscsiIQN;
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="attachedTransferPackageLabel")
    private final String attachedTransferPackageLabel;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="uploadStatusLogUri")
    private final String uploadStatusLogUri;

    @Deprecated
    @ConstructorProperties(value={"serialNumber", "iscsiIQN", "label", "lifecycleState", "attachedTransferPackageLabel", "creationTime", "uploadStatusLogUri"})
    public TransferDeviceSummary(String serialNumber, String iscsiIQN, String label, LifecycleState lifecycleState, String attachedTransferPackageLabel, Date creationTime, String uploadStatusLogUri) {
        this.serialNumber = serialNumber;
        this.iscsiIQN = iscsiIQN;
        this.label = label;
        this.lifecycleState = lifecycleState;
        this.attachedTransferPackageLabel = attachedTransferPackageLabel;
        this.creationTime = creationTime;
        this.uploadStatusLogUri = uploadStatusLogUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getIscsiIQN() {
        return this.iscsiIQN;
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAttachedTransferPackageLabel() {
        return this.attachedTransferPackageLabel;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getUploadStatusLogUri() {
        return this.uploadStatusLogUri;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferDeviceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", iscsiIQN=").append(String.valueOf(this.iscsiIQN));
        sb.append(", label=").append(String.valueOf(this.label));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", attachedTransferPackageLabel=").append(String.valueOf(this.attachedTransferPackageLabel));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(", uploadStatusLogUri=").append(String.valueOf(this.uploadStatusLogUri));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferDeviceSummary)) {
            return false;
        }
        TransferDeviceSummary other = (TransferDeviceSummary)((Object)o);
        return Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.iscsiIQN, other.iscsiIQN) && Objects.equals(this.label, other.label) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.attachedTransferPackageLabel, other.attachedTransferPackageLabel) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.uploadStatusLogUri, other.uploadStatusLogUri) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.iscsiIQN == null ? 43 : this.iscsiIQN.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.attachedTransferPackageLabel == null ? 43 : this.attachedTransferPackageLabel.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + (this.uploadStatusLogUri == null ? 43 : this.uploadStatusLogUri.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Preparing("PREPARING"),
        Ready("READY"),
        Packaged("PACKAGED"),
        Active("ACTIVE"),
        Processing("PROCESSING"),
        Complete("COMPLETE"),
        Missing("MISSING"),
        Error("ERROR"),
        Deleted("DELETED"),
        Cancelled("CANCELLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="iscsiIQN")
        private String iscsiIQN;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="attachedTransferPackageLabel")
        private String attachedTransferPackageLabel;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="uploadStatusLogUri")
        private String uploadStatusLogUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder iscsiIQN(String iscsiIQN) {
            this.iscsiIQN = iscsiIQN;
            this.__explicitlySet__.add("iscsiIQN");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder attachedTransferPackageLabel(String attachedTransferPackageLabel) {
            this.attachedTransferPackageLabel = attachedTransferPackageLabel;
            this.__explicitlySet__.add("attachedTransferPackageLabel");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder uploadStatusLogUri(String uploadStatusLogUri) {
            this.uploadStatusLogUri = uploadStatusLogUri;
            this.__explicitlySet__.add("uploadStatusLogUri");
            return this;
        }

        public TransferDeviceSummary build() {
            TransferDeviceSummary model = new TransferDeviceSummary(this.serialNumber, this.iscsiIQN, this.label, this.lifecycleState, this.attachedTransferPackageLabel, this.creationTime, this.uploadStatusLogUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TransferDeviceSummary model) {
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("iscsiIQN")) {
                this.iscsiIQN(model.getIscsiIQN());
            }
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("attachedTransferPackageLabel")) {
                this.attachedTransferPackageLabel(model.getAttachedTransferPackageLabel());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            if (model.wasPropertyExplicitlySet("uploadStatusLogUri")) {
                this.uploadStatusLogUri(model.getUploadStatusLogUri());
            }
            return this;
        }
    }
}

