/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferPackageAsync;
import com.oracle.bmc.dts.model.MultipleTransferPackages;
import com.oracle.bmc.dts.model.TransferPackage;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPackageAsyncClient
extends BaseAsyncClient
implements TransferPackageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferPackageAsyncClient.class);

    private TransferPackageAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AttachDevicesToTransferPackageResponse> attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request, AsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachDevicesDetails(), "attachDevicesDetails is required");
        return this.clientCall(request, AttachDevicesToTransferPackageResponse::builder).logger(LOG, "attachDevicesToTransferPackage").serviceDetails("TransferPackage", "AttachDevicesToTransferPackage", "").method(Method.POST).requestBuilder(AttachDevicesToTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).appendPathParam("actions").appendPathParam("attachDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AttachDevicesToTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AttachDevicesToTransferPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTransferPackageResponse> createTransferPackage(CreateTransferPackageRequest request, AsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateTransferPackageResponse::builder).logger(LOG, "createTransferPackage").serviceDetails("TransferPackage", "CreateTransferPackage", "").method(Method.POST).requestBuilder(CreateTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TransferPackage.class, CreateTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", CreateTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteTransferPackageResponse> deleteTransferPackage(DeleteTransferPackageRequest request, AsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTransferPackageResponse::builder).logger(LOG, "deleteTransferPackage").serviceDetails("TransferPackage", "DeleteTransferPackage", "").method(Method.DELETE).requestBuilder(DeleteTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachDevicesFromTransferPackageResponse> detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request, AsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachDevicesDetails(), "detachDevicesDetails is required");
        return this.clientCall(request, DetachDevicesFromTransferPackageResponse::builder).logger(LOG, "detachDevicesFromTransferPackage").serviceDetails("TransferPackage", "DetachDevicesFromTransferPackage", "").method(Method.POST).requestBuilder(DetachDevicesFromTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).appendPathParam("actions").appendPathParam("detachDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetachDevicesFromTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DetachDevicesFromTransferPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetTransferPackageResponse> getTransferPackage(GetTransferPackageRequest request, AsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTransferPackageResponse::builder).logger(LOG, "getTransferPackage").serviceDetails("TransferPackage", "GetTransferPackage", "").method(Method.GET).requestBuilder(GetTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).handleBody(TransferPackage.class, GetTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", GetTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListTransferPackagesResponse> listTransferPackages(ListTransferPackagesRequest request, AsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTransferPackagesResponse::builder).logger(LOG, "listTransferPackages").serviceDetails("TransferPackage", "ListTransferPackages", "").method(Method.GET).requestBuilder(ListTransferPackagesRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).handleBody(MultipleTransferPackages.class, ListTransferPackagesResponse.Builder::multipleTransferPackages).handleResponseHeaderString("opc-request-id", ListTransferPackagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTransferPackageResponse> updateTransferPackage(UpdateTransferPackageRequest request, AsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferPackageLabel(), (String)"transferPackageLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferPackageDetails(), "updateTransferPackageDetails is required");
        return this.clientCall(request, UpdateTransferPackageResponse::builder).logger(LOG, "updateTransferPackage").serviceDetails("TransferPackage", "UpdateTransferPackage", "").method(Method.PUT).requestBuilder(UpdateTransferPackageRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferPackages").appendPathParam(request.getTransferPackageLabel()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(TransferPackage.class, UpdateTransferPackageResponse.Builder::transferPackage).handleResponseHeaderString("opc-request-id", UpdateTransferPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferPackageResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferPackageAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferPackageAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferPackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferPackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferPackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferPackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferPackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferPackageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferPackageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferPackageAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

