/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferJobAsyncClient;
import com.oracle.bmc.dts.TransferJobPaginators;
import com.oracle.bmc.dts.TransferJobWaiters;
import com.oracle.bmc.dts.model.TransferJob;
import com.oracle.bmc.dts.model.TransferJobSummary;
import com.oracle.bmc.dts.requests.ChangeTransferJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateTransferJobRequest;
import com.oracle.bmc.dts.requests.DeleteTransferJobRequest;
import com.oracle.bmc.dts.requests.GetTransferJobRequest;
import com.oracle.bmc.dts.requests.ListTransferJobsRequest;
import com.oracle.bmc.dts.requests.UpdateTransferJobRequest;
import com.oracle.bmc.dts.responses.ChangeTransferJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateTransferJobResponse;
import com.oracle.bmc.dts.responses.DeleteTransferJobResponse;
import com.oracle.bmc.dts.responses.GetTransferJobResponse;
import com.oracle.bmc.dts.responses.ListTransferJobsResponse;
import com.oracle.bmc.dts.responses.UpdateTransferJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJobClient
extends BaseSyncClient
implements com.oracle.bmc.dts.TransferJob {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferJobAsyncClient.class);
    private final TransferJobWaiters waiters;
    private final TransferJobPaginators paginators;

    private TransferJobClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("TransferJob-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferJobWaiters(executorService, this);
        this.paginators = new TransferJobPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeTransferJobCompartmentResponse changeTransferJobCompartment(ChangeTransferJobCompartmentRequest request) {
        Validate.notBlank((String)request.getTransferJobId(), (String)"transferJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTransferJobCompartmentDetails(), "changeTransferJobCompartmentDetails is required");
        return (ChangeTransferJobCompartmentResponse)this.clientCall(request, ChangeTransferJobCompartmentResponse::builder).logger(LOG, "changeTransferJobCompartment").serviceDetails("TransferJob", "ChangeTransferJobCompartment", "").method(Method.POST).requestBuilder(ChangeTransferJobCompartmentRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getTransferJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTransferJobCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ChangeTransferJobCompartmentResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTransferJobResponse createTransferJob(CreateTransferJobRequest request) {
        Objects.requireNonNull(request.getCreateTransferJobDetails(), "createTransferJobDetails is required");
        return (CreateTransferJobResponse)this.clientCall(request, CreateTransferJobResponse::builder).logger(LOG, "createTransferJob").serviceDetails("TransferJob", "CreateTransferJob", "").method(Method.POST).requestBuilder(CreateTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TransferJob.class, CreateTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", CreateTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferJobResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteTransferJobResponse deleteTransferJob(DeleteTransferJobRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (DeleteTransferJobResponse)this.clientCall(request, DeleteTransferJobResponse::builder).logger(LOG, "deleteTransferJob").serviceDetails("TransferJob", "DeleteTransferJob", "").method(Method.DELETE).requestBuilder(DeleteTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTransferJobResponse getTransferJob(GetTransferJobRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (GetTransferJobResponse)this.clientCall(request, GetTransferJobResponse::builder).logger(LOG, "getTransferJob").serviceDetails("TransferJob", "GetTransferJob", "").method(Method.GET).requestBuilder(GetTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TransferJob.class, GetTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", GetTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferJobResponse.Builder::etag).callSync();
    }

    @Override
    public ListTransferJobsResponse listTransferJobs(ListTransferJobsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTransferJobsResponse)this.clientCall(request, ListTransferJobsResponse::builder).logger(LOG, "listTransferJobs").serviceDetails("TransferJob", "ListTransferJobs", "").method(Method.GET).requestBuilder(ListTransferJobsRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TransferJobSummary.class, ListTransferJobsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListTransferJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListTransferJobsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTransferJobResponse updateTransferJob(UpdateTransferJobRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferJobDetails(), "updateTransferJobDetails is required");
        return (UpdateTransferJobResponse)this.clientCall(request, UpdateTransferJobResponse::builder).logger(LOG, "updateTransferJob").serviceDetails("TransferJob", "UpdateTransferJob", "").method(Method.PUT).requestBuilder(UpdateTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TransferJob.class, UpdateTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", UpdateTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferJobResponse.Builder::etag).callSync();
    }

    @Override
    public TransferJobWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public TransferJobPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public TransferJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferJobClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferJobClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferJobClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferJobClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferJobClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferJobClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferJobClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

