/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferJobAsync;
import com.oracle.bmc.dts.model.TransferJob;
import com.oracle.bmc.dts.model.TransferJobSummary;
import com.oracle.bmc.dts.requests.ChangeTransferJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateTransferJobRequest;
import com.oracle.bmc.dts.requests.DeleteTransferJobRequest;
import com.oracle.bmc.dts.requests.GetTransferJobRequest;
import com.oracle.bmc.dts.requests.ListTransferJobsRequest;
import com.oracle.bmc.dts.requests.UpdateTransferJobRequest;
import com.oracle.bmc.dts.responses.ChangeTransferJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateTransferJobResponse;
import com.oracle.bmc.dts.responses.DeleteTransferJobResponse;
import com.oracle.bmc.dts.responses.GetTransferJobResponse;
import com.oracle.bmc.dts.responses.ListTransferJobsResponse;
import com.oracle.bmc.dts.responses.UpdateTransferJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJobAsyncClient
extends BaseAsyncClient
implements TransferJobAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferJobAsyncClient.class);

    private TransferJobAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeTransferJobCompartmentResponse> changeTransferJobCompartment(ChangeTransferJobCompartmentRequest request, AsyncHandler<ChangeTransferJobCompartmentRequest, ChangeTransferJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getTransferJobId(), (String)"transferJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTransferJobCompartmentDetails(), "changeTransferJobCompartmentDetails is required");
        return this.clientCall(request, ChangeTransferJobCompartmentResponse::builder).logger(LOG, "changeTransferJobCompartment").serviceDetails("TransferJob", "ChangeTransferJobCompartment", "").method(Method.POST).requestBuilder(ChangeTransferJobCompartmentRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getTransferJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTransferJobCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ChangeTransferJobCompartmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateTransferJobResponse> createTransferJob(CreateTransferJobRequest request, AsyncHandler<CreateTransferJobRequest, CreateTransferJobResponse> handler) {
        Objects.requireNonNull(request.getCreateTransferJobDetails(), "createTransferJobDetails is required");
        return this.clientCall(request, CreateTransferJobResponse::builder).logger(LOG, "createTransferJob").serviceDetails("TransferJob", "CreateTransferJob", "").method(Method.POST).requestBuilder(CreateTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TransferJob.class, CreateTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", CreateTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteTransferJobResponse> deleteTransferJob(DeleteTransferJobRequest request, AsyncHandler<DeleteTransferJobRequest, DeleteTransferJobResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTransferJobResponse::builder).logger(LOG, "deleteTransferJob").serviceDetails("TransferJob", "DeleteTransferJob", "").method(Method.DELETE).requestBuilder(DeleteTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTransferJobResponse> getTransferJob(GetTransferJobRequest request, AsyncHandler<GetTransferJobRequest, GetTransferJobResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTransferJobResponse::builder).logger(LOG, "getTransferJob").serviceDetails("TransferJob", "GetTransferJob", "").method(Method.GET).requestBuilder(GetTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TransferJob.class, GetTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", GetTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListTransferJobsResponse> listTransferJobs(ListTransferJobsRequest request, AsyncHandler<ListTransferJobsRequest, ListTransferJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTransferJobsResponse::builder).logger(LOG, "listTransferJobs").serviceDetails("TransferJob", "ListTransferJobs", "").method(Method.GET).requestBuilder(ListTransferJobsRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TransferJobSummary.class, ListTransferJobsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListTransferJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListTransferJobsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTransferJobResponse> updateTransferJob(UpdateTransferJobRequest request, AsyncHandler<UpdateTransferJobRequest, UpdateTransferJobResponse> handler) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferJobDetails(), "updateTransferJobDetails is required");
        return this.clientCall(request, UpdateTransferJobResponse::builder).logger(LOG, "updateTransferJob").serviceDetails("TransferJob", "UpdateTransferJob", "").method(Method.PUT).requestBuilder(UpdateTransferJobRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TransferJob.class, UpdateTransferJobResponse.Builder::transferJob).handleResponseHeaderString("opc-request-id", UpdateTransferJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferJobResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferJobAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferJobAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public TransferJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferJobAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferJobAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

