/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.dts.TransferDevice;
import com.oracle.bmc.dts.model.TransferDevice;
import com.oracle.bmc.dts.requests.GetTransferDeviceRequest;
import com.oracle.bmc.dts.responses.GetTransferDeviceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransferDeviceWaiters {
    private final ExecutorService executorService;
    private final TransferDevice client;

    public TransferDeviceWaiters(ExecutorService executorService, TransferDevice client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetTransferDeviceRequest, GetTransferDeviceResponse> forTransferDevice(GetTransferDeviceRequest request, TransferDevice.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTransferDevice(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTransferDeviceRequest, GetTransferDeviceResponse> forTransferDevice(GetTransferDeviceRequest request, TransferDevice.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTransferDevice(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTransferDeviceRequest, GetTransferDeviceResponse> forTransferDevice(GetTransferDeviceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TransferDevice.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTransferDevice(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTransferDeviceRequest, GetTransferDeviceResponse> forTransferDevice(BmcGenericWaiter waiter, GetTransferDeviceRequest request, TransferDevice.LifecycleState ... targetStates) {
        final HashSet<TransferDevice.LifecycleState> targetStatesSet = new HashSet<TransferDevice.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTransferDeviceRequest, GetTransferDeviceResponse>(){

            @Override
            public GetTransferDeviceResponse apply(GetTransferDeviceRequest request) {
                return TransferDeviceWaiters.this.client.getTransferDevice(request);
            }
        }, (Predicate)new Predicate<GetTransferDeviceResponse>(){

            @Override
            public boolean test(GetTransferDeviceResponse response) {
                return targetStatesSet.contains((Object)response.getTransferDevice().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TransferDevice.LifecycleState.Deleted)), (Object)request);
    }
}

