/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferDeviceAsyncClient;
import com.oracle.bmc.dts.TransferDeviceWaiters;
import com.oracle.bmc.dts.model.MultipleTransferDevices;
import com.oracle.bmc.dts.model.NewTransferDevice;
import com.oracle.bmc.dts.model.TransferDevice;
import com.oracle.bmc.dts.requests.CreateTransferDeviceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferDeviceRequest;
import com.oracle.bmc.dts.requests.GetTransferDeviceRequest;
import com.oracle.bmc.dts.requests.ListTransferDevicesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferDeviceRequest;
import com.oracle.bmc.dts.responses.CreateTransferDeviceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferDeviceResponse;
import com.oracle.bmc.dts.responses.GetTransferDeviceResponse;
import com.oracle.bmc.dts.responses.ListTransferDevicesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferDeviceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDeviceClient
extends BaseSyncClient
implements com.oracle.bmc.dts.TransferDevice {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERDEVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferDeviceAsyncClient.class);
    private final TransferDeviceWaiters waiters;

    private TransferDeviceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("TransferDevice-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferDeviceWaiters(executorService, this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateTransferDeviceResponse createTransferDevice(CreateTransferDeviceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTransferDeviceDetails(), "createTransferDeviceDetails is required");
        return (CreateTransferDeviceResponse)this.clientCall(request, CreateTransferDeviceResponse::builder).logger(LOG, "createTransferDevice").serviceDetails("TransferDevice", "CreateTransferDevice", "").method(Method.POST).requestBuilder(CreateTransferDeviceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferDevices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NewTransferDevice.class, CreateTransferDeviceResponse.Builder::newTransferDevice).handleResponseHeaderString("opc-request-id", CreateTransferDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferDeviceResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteTransferDeviceResponse deleteTransferDevice(DeleteTransferDeviceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferDeviceLabel(), (String)"transferDeviceLabel must not be blank", (Object[])new Object[0]);
        return (DeleteTransferDeviceResponse)this.clientCall(request, DeleteTransferDeviceResponse::builder).logger(LOG, "deleteTransferDevice").serviceDetails("TransferDevice", "DeleteTransferDevice", "").method(Method.DELETE).requestBuilder(DeleteTransferDeviceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferDevices").appendPathParam(request.getTransferDeviceLabel()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferDeviceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTransferDeviceResponse getTransferDevice(GetTransferDeviceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferDeviceLabel(), (String)"transferDeviceLabel must not be blank", (Object[])new Object[0]);
        return (GetTransferDeviceResponse)this.clientCall(request, GetTransferDeviceResponse::builder).logger(LOG, "getTransferDevice").serviceDetails("TransferDevice", "GetTransferDevice", "").method(Method.GET).requestBuilder(GetTransferDeviceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferDevices").appendPathParam(request.getTransferDeviceLabel()).accept(new String[]{"application/json"}).handleBody(TransferDevice.class, GetTransferDeviceResponse.Builder::transferDevice).handleResponseHeaderString("opc-request-id", GetTransferDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferDeviceResponse.Builder::etag).callSync();
    }

    @Override
    public ListTransferDevicesResponse listTransferDevices(ListTransferDevicesRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (ListTransferDevicesResponse)this.clientCall(request, ListTransferDevicesResponse::builder).logger(LOG, "listTransferDevices").serviceDetails("TransferDevice", "ListTransferDevices", "").method(Method.GET).requestBuilder(ListTransferDevicesRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferDevices").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).handleBody(MultipleTransferDevices.class, ListTransferDevicesResponse.Builder::multipleTransferDevices).handleResponseHeaderString("opc-request-id", ListTransferDevicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTransferDeviceResponse updateTransferDevice(UpdateTransferDeviceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferDeviceLabel(), (String)"transferDeviceLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferDeviceDetails(), "updateTransferDeviceDetails is required");
        return (UpdateTransferDeviceResponse)this.clientCall(request, UpdateTransferDeviceResponse::builder).logger(LOG, "updateTransferDevice").serviceDetails("TransferDevice", "UpdateTransferDevice", "").method(Method.PUT).requestBuilder(UpdateTransferDeviceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferDevices").appendPathParam(request.getTransferDeviceLabel()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(TransferDevice.class, UpdateTransferDeviceResponse.Builder::transferDevice).handleResponseHeaderString("opc-request-id", UpdateTransferDeviceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferDeviceResponse.Builder::etag).callSync();
    }

    @Override
    public TransferDeviceWaiters getWaiters() {
        return this.waiters;
    }

    @Deprecated
    public TransferDeviceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferDeviceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferDeviceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferDeviceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferDeviceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferDeviceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferDeviceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferDeviceClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

