/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.dts.TransferAppliance;
import com.oracle.bmc.dts.model.TransferAppliance;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransferApplianceWaiters {
    private final ExecutorService executorService;
    private final TransferAppliance client;

    public TransferApplianceWaiters(ExecutorService executorService, TransferAppliance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetTransferApplianceRequest, GetTransferApplianceResponse> forTransferAppliance(GetTransferApplianceRequest request, TransferAppliance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTransferAppliance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTransferApplianceRequest, GetTransferApplianceResponse> forTransferAppliance(GetTransferApplianceRequest request, TransferAppliance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTransferAppliance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTransferApplianceRequest, GetTransferApplianceResponse> forTransferAppliance(GetTransferApplianceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TransferAppliance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTransferAppliance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTransferApplianceRequest, GetTransferApplianceResponse> forTransferAppliance(BmcGenericWaiter waiter, GetTransferApplianceRequest request, TransferAppliance.LifecycleState ... targetStates) {
        final HashSet<TransferAppliance.LifecycleState> targetStatesSet = new HashSet<TransferAppliance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTransferApplianceRequest, GetTransferApplianceResponse>(){

            @Override
            public GetTransferApplianceResponse apply(GetTransferApplianceRequest request) {
                return TransferApplianceWaiters.this.client.getTransferAppliance(request);
            }
        }, (Predicate)new Predicate<GetTransferApplianceResponse>(){

            @Override
            public boolean test(GetTransferApplianceResponse response) {
                return targetStatesSet.contains((Object)response.getTransferAppliance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TransferAppliance.LifecycleState.Deleted)), (Object)request);
    }
}

