/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferApplianceEntitlementAsyncClient;
import com.oracle.bmc.dts.TransferApplianceEntitlementWaiters;
import com.oracle.bmc.dts.model.TransferApplianceEntitlement;
import com.oracle.bmc.dts.model.TransferApplianceEntitlementSummary;
import com.oracle.bmc.dts.requests.CreateTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.requests.ListTransferApplianceEntitlementRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEntitlementResponse;
import com.oracle.bmc.dts.responses.ListTransferApplianceEntitlementResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceEntitlementClient
extends BaseSyncClient
implements com.oracle.bmc.dts.TransferApplianceEntitlement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCEENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceEntitlementAsyncClient.class);
    private final TransferApplianceEntitlementWaiters waiters;

    private TransferApplianceEntitlementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("TransferApplianceEntitlement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferApplianceEntitlementWaiters(executorService, this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateTransferApplianceEntitlementResponse createTransferApplianceEntitlement(CreateTransferApplianceEntitlementRequest request) {
        Objects.requireNonNull(request.getCreateTransferApplianceEntitlementDetails(), "createTransferApplianceEntitlementDetails is required");
        return (CreateTransferApplianceEntitlementResponse)this.clientCall(request, CreateTransferApplianceEntitlementResponse::builder).logger(LOG, "createTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "CreateTransferApplianceEntitlement", "").method(Method.POST).requestBuilder(CreateTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TransferApplianceEntitlement.class, CreateTransferApplianceEntitlementResponse.Builder::transferApplianceEntitlement).handleResponseHeaderString("opc-request-id", CreateTransferApplianceEntitlementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferApplianceEntitlementResponse.Builder::etag).callSync();
    }

    @Override
    public GetTransferApplianceEntitlementResponse getTransferApplianceEntitlement(GetTransferApplianceEntitlementRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (GetTransferApplianceEntitlementResponse)this.clientCall(request, GetTransferApplianceEntitlementResponse::builder).logger(LOG, "getTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "GetTransferApplianceEntitlement", "").method(Method.GET).requestBuilder(GetTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").appendPathParam(request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TransferApplianceEntitlement.class, GetTransferApplianceEntitlementResponse.Builder::transferApplianceEntitlement).handleResponseHeaderString("opc-request-id", GetTransferApplianceEntitlementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListTransferApplianceEntitlementResponse listTransferApplianceEntitlement(ListTransferApplianceEntitlementRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTransferApplianceEntitlementResponse)this.clientCall(request, ListTransferApplianceEntitlementResponse::builder).logger(LOG, "listTransferApplianceEntitlement").serviceDetails("TransferApplianceEntitlement", "ListTransferApplianceEntitlement", "").method(Method.GET).requestBuilder(ListTransferApplianceEntitlementRequest::builder).basePath("/20171001").appendPathParam("transferApplianceEntitlement").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(TransferApplianceEntitlementSummary.class, ListTransferApplianceEntitlementResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListTransferApplianceEntitlementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TransferApplianceEntitlementWaiters getWaiters() {
        return this.waiters;
    }

    @Deprecated
    public TransferApplianceEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferApplianceEntitlementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferApplianceEntitlementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceEntitlementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferApplianceEntitlementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceEntitlementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferApplianceEntitlementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferApplianceEntitlementClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

