/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferAppliance;
import com.oracle.bmc.dts.TransferApplianceAsyncClient;
import com.oracle.bmc.dts.TransferApplianceWaiters;
import com.oracle.bmc.dts.model.MultipleTransferAppliances;
import com.oracle.bmc.dts.model.TransferApplianceCertificate;
import com.oracle.bmc.dts.model.TransferApplianceEncryptionPassphrase;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceClient
extends BaseSyncClient
implements TransferAppliance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceAsyncClient.class);
    private final TransferApplianceWaiters waiters;

    private TransferApplianceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("TransferAppliance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferApplianceWaiters(executorService, this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateTransferApplianceResponse createTransferAppliance(CreateTransferApplianceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (CreateTransferApplianceResponse)this.clientCall(request, CreateTransferApplianceResponse::builder).logger(LOG, "createTransferAppliance").serviceDetails("TransferAppliance", "CreateTransferAppliance", "").method(Method.POST).requestBuilder(CreateTransferApplianceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(com.oracle.bmc.dts.model.TransferAppliance.class, CreateTransferApplianceResponse.Builder::transferAppliance).handleResponseHeaderString("opc-request-id", CreateTransferApplianceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferApplianceResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTransferApplianceAdminCredentialsResponse createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAdminPublicKey(), "adminPublicKey is required");
        return (CreateTransferApplianceAdminCredentialsResponse)this.clientCall(request, CreateTransferApplianceAdminCredentialsResponse::builder).logger(LOG, "createTransferApplianceAdminCredentials").serviceDetails("TransferAppliance", "CreateTransferApplianceAdminCredentials", "").method(Method.POST).requestBuilder(CreateTransferApplianceAdminCredentialsRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).appendPathParam("admin_credentials").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TransferApplianceCertificate.class, CreateTransferApplianceAdminCredentialsResponse.Builder::transferApplianceCertificate).handleResponseHeaderString("opc-request-id", CreateTransferApplianceAdminCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTransferApplianceAdminCredentialsResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteTransferApplianceResponse deleteTransferAppliance(DeleteTransferApplianceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        return (DeleteTransferApplianceResponse)this.clientCall(request, DeleteTransferApplianceResponse::builder).logger(LOG, "deleteTransferAppliance").serviceDetails("TransferAppliance", "DeleteTransferAppliance", "").method(Method.DELETE).requestBuilder(DeleteTransferApplianceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteTransferApplianceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTransferApplianceResponse getTransferAppliance(GetTransferApplianceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        return (GetTransferApplianceResponse)this.clientCall(request, GetTransferApplianceResponse::builder).logger(LOG, "getTransferAppliance").serviceDetails("TransferAppliance", "GetTransferAppliance", "").method(Method.GET).requestBuilder(GetTransferApplianceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).accept(new String[]{"application/json"}).handleBody(com.oracle.bmc.dts.model.TransferAppliance.class, GetTransferApplianceResponse.Builder::transferAppliance).handleResponseHeaderString("opc-request-id", GetTransferApplianceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferApplianceResponse.Builder::etag).callSync();
    }

    @Override
    public GetTransferApplianceCertificateAuthorityCertificateResponse getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        return (GetTransferApplianceCertificateAuthorityCertificateResponse)this.clientCall(request, GetTransferApplianceCertificateAuthorityCertificateResponse::builder).logger(LOG, "getTransferApplianceCertificateAuthorityCertificate").serviceDetails("TransferAppliance", "GetTransferApplianceCertificateAuthorityCertificate", "").method(Method.GET).requestBuilder(GetTransferApplianceCertificateAuthorityCertificateRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).appendPathParam("certificate_authority_certificate").accept(new String[]{"application/json"}).handleBody(TransferApplianceCertificate.class, GetTransferApplianceCertificateAuthorityCertificateResponse.Builder::transferApplianceCertificate).handleResponseHeaderString("opc-request-id", GetTransferApplianceCertificateAuthorityCertificateResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferApplianceCertificateAuthorityCertificateResponse.Builder::etag).callSync();
    }

    @Override
    public GetTransferApplianceEncryptionPassphraseResponse getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        return (GetTransferApplianceEncryptionPassphraseResponse)this.clientCall(request, GetTransferApplianceEncryptionPassphraseResponse::builder).logger(LOG, "getTransferApplianceEncryptionPassphrase").serviceDetails("TransferAppliance", "GetTransferApplianceEncryptionPassphrase", "").method(Method.GET).requestBuilder(GetTransferApplianceEncryptionPassphraseRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).appendPathParam("encryptionPassphrase").accept(new String[]{"application/json"}).handleBody(TransferApplianceEncryptionPassphrase.class, GetTransferApplianceEncryptionPassphraseResponse.Builder::transferApplianceEncryptionPassphrase).handleResponseHeaderString("opc-request-id", GetTransferApplianceEncryptionPassphraseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTransferApplianceEncryptionPassphraseResponse.Builder::etag).callSync();
    }

    @Override
    public ListTransferAppliancesResponse listTransferAppliances(ListTransferAppliancesRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (ListTransferAppliancesResponse)this.clientCall(request, ListTransferAppliancesResponse::builder).logger(LOG, "listTransferAppliances").serviceDetails("TransferAppliance", "ListTransferAppliances", "").method(Method.GET).requestBuilder(ListTransferAppliancesRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBody(MultipleTransferAppliances.class, ListTransferAppliancesResponse.Builder::multipleTransferAppliances).handleResponseHeaderString("opc-request-id", ListTransferAppliancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTransferApplianceResponse updateTransferAppliance(UpdateTransferApplianceRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTransferApplianceLabel(), (String)"transferApplianceLabel must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTransferApplianceDetails(), "updateTransferApplianceDetails is required");
        return (UpdateTransferApplianceResponse)this.clientCall(request, UpdateTransferApplianceResponse::builder).logger(LOG, "updateTransferAppliance").serviceDetails("TransferAppliance", "UpdateTransferAppliance", "").method(Method.PUT).requestBuilder(UpdateTransferApplianceRequest::builder).basePath("/20171001").appendPathParam("transferJobs").appendPathParam(request.getId()).appendPathParam("transferAppliances").appendPathParam(request.getTransferApplianceLabel()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(com.oracle.bmc.dts.model.TransferAppliance.class, UpdateTransferApplianceResponse.Builder::transferAppliance).handleResponseHeaderString("opc-request-id", UpdateTransferApplianceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTransferApplianceResponse.Builder::etag).callSync();
    }

    @Override
    public TransferApplianceWaiters getWaiters() {
        return this.waiters;
    }

    @Deprecated
    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TransferApplianceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TransferApplianceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TransferApplianceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferApplianceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TransferApplianceClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

