/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.ApplianceExportJobAsync;
import com.oracle.bmc.dts.model.ApplianceExportJob;
import com.oracle.bmc.dts.model.ApplianceExportJobSummary;
import com.oracle.bmc.dts.requests.ChangeApplianceExportJobCompartmentRequest;
import com.oracle.bmc.dts.requests.CreateApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.DeleteApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.GetApplianceExportJobRequest;
import com.oracle.bmc.dts.requests.ListApplianceExportJobsRequest;
import com.oracle.bmc.dts.requests.UpdateApplianceExportJobRequest;
import com.oracle.bmc.dts.responses.ChangeApplianceExportJobCompartmentResponse;
import com.oracle.bmc.dts.responses.CreateApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.DeleteApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.GetApplianceExportJobResponse;
import com.oracle.bmc.dts.responses.ListApplianceExportJobsResponse;
import com.oracle.bmc.dts.responses.UpdateApplianceExportJobResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplianceExportJobAsyncClient
extends BaseAsyncClient
implements ApplianceExportJobAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLIANCEEXPORTJOB").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApplianceExportJobAsyncClient.class);

    private ApplianceExportJobAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeApplianceExportJobCompartmentResponse> changeApplianceExportJobCompartment(ChangeApplianceExportJobCompartmentRequest request, AsyncHandler<ChangeApplianceExportJobCompartmentRequest, ChangeApplianceExportJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApplianceExportJobCompartmentDetails(), "changeApplianceExportJobCompartmentDetails is required");
        return this.clientCall(request, ChangeApplianceExportJobCompartmentResponse::builder).logger(LOG, "changeApplianceExportJobCompartment").serviceDetails("ApplianceExportJob", "ChangeApplianceExportJobCompartment", "").method(Method.POST).requestBuilder(ChangeApplianceExportJobCompartmentRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeApplianceExportJobCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApplianceExportJobResponse> createApplianceExportJob(CreateApplianceExportJobRequest request, AsyncHandler<CreateApplianceExportJobRequest, CreateApplianceExportJobResponse> handler) {
        Objects.requireNonNull(request.getCreateApplianceExportJobDetails(), "createApplianceExportJobDetails is required");
        return this.clientCall(request, CreateApplianceExportJobResponse::builder).logger(LOG, "createApplianceExportJob").serviceDetails("ApplianceExportJob", "CreateApplianceExportJob", "").method(Method.POST).requestBuilder(CreateApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ApplianceExportJob.class, CreateApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", CreateApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateApplianceExportJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteApplianceExportJobResponse> deleteApplianceExportJob(DeleteApplianceExportJobRequest request, AsyncHandler<DeleteApplianceExportJobRequest, DeleteApplianceExportJobResponse> handler) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApplianceExportJobResponse::builder).logger(LOG, "deleteApplianceExportJob").serviceDetails("ApplianceExportJob", "DeleteApplianceExportJob", "").method(Method.DELETE).requestBuilder(DeleteApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteApplianceExportJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApplianceExportJobResponse> getApplianceExportJob(GetApplianceExportJobRequest request, AsyncHandler<GetApplianceExportJobRequest, GetApplianceExportJobResponse> handler) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApplianceExportJobResponse::builder).logger(LOG, "getApplianceExportJob").serviceDetails("ApplianceExportJob", "GetApplianceExportJob", "").method(Method.GET).requestBuilder(GetApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplianceExportJob.class, GetApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", GetApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetApplianceExportJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListApplianceExportJobsResponse> listApplianceExportJobs(ListApplianceExportJobsRequest request, AsyncHandler<ListApplianceExportJobsRequest, ListApplianceExportJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApplianceExportJobsResponse::builder).logger(LOG, "listApplianceExportJobs").serviceDetails("ApplianceExportJob", "ListApplianceExportJobs", "").method(Method.GET).requestBuilder(ListApplianceExportJobsRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApplianceExportJobSummary.class, ListApplianceExportJobsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListApplianceExportJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListApplianceExportJobsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateApplianceExportJobResponse> updateApplianceExportJob(UpdateApplianceExportJobRequest request, AsyncHandler<UpdateApplianceExportJobRequest, UpdateApplianceExportJobResponse> handler) {
        Validate.notBlank((String)request.getApplianceExportJobId(), (String)"applianceExportJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApplianceExportJobDetails(), "updateApplianceExportJobDetails is required");
        return this.clientCall(request, UpdateApplianceExportJobResponse::builder).logger(LOG, "updateApplianceExportJob").serviceDetails("ApplianceExportJob", "UpdateApplianceExportJob", "").method(Method.PUT).requestBuilder(UpdateApplianceExportJobRequest::builder).basePath("/20171001").appendPathParam("applianceExportJobs").appendPathParam(request.getApplianceExportJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ApplianceExportJob.class, UpdateApplianceExportJobResponse.Builder::applianceExportJob).handleResponseHeaderString("opc-request-id", UpdateApplianceExportJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateApplianceExportJobResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApplianceExportJobAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApplianceExportJobAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApplianceExportJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApplianceExportJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApplianceExportJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApplianceExportJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ApplianceExportJobAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplianceExportJobAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplianceExportJobAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApplianceExportJobAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApplianceExportJobAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

