/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetResolverEndpointResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private ResolverEndpoint resolverEndpoint;
    private boolean isNotModified;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ResolverEndpoint getResolverEndpoint() {
        return this.resolverEndpoint;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "resolverEndpoint", "isNotModified"})
    private GetResolverEndpointResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, ResolverEndpoint resolverEndpoint, boolean isNotModified) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.resolverEndpoint = resolverEndpoint;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",resolverEndpoint=").append(String.valueOf((Object)this.resolverEndpoint));
        sb.append(",isNotModified=").append(this.isNotModified);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResolverEndpointResponse)) {
            return false;
        }
        GetResolverEndpointResponse other = (GetResolverEndpointResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.resolverEndpoint, (Object)other.resolverEndpoint) && this.isNotModified == other.isNotModified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.resolverEndpoint == null ? 43 : this.resolverEndpoint.hashCode());
        result = result * 59 + (this.isNotModified ? 79 : 97);
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetResolverEndpointResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private ResolverEndpoint resolverEndpoint;
        private boolean isNotModified;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resolverEndpoint(ResolverEndpoint resolverEndpoint) {
            this.resolverEndpoint = resolverEndpoint;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public Builder copy(GetResolverEndpointResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.resolverEndpoint(o.getResolverEndpoint());
            this.isNotModified(o.isNotModified());
            return this;
        }

        public GetResolverEndpointResponse build() {
            return new GetResolverEndpointResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.resolverEndpoint, this.isNotModified);
        }
    }
}

