/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.UpdateResolverEndpointDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateResolverEndpointRequest
extends BmcRequest<UpdateResolverEndpointDetails> {
    private String resolverId;
    private String resolverEndpointName;
    private UpdateResolverEndpointDetails updateResolverEndpointDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;

    public String getResolverId() {
        return this.resolverId;
    }

    public String getResolverEndpointName() {
        return this.resolverEndpointName;
    }

    public UpdateResolverEndpointDetails getUpdateResolverEndpointDetails() {
        return this.updateResolverEndpointDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    @InternalSdk
    public UpdateResolverEndpointDetails getBody$() {
        return this.updateResolverEndpointDetails;
    }

    public Builder toBuilder() {
        return new Builder().resolverId(this.resolverId).resolverEndpointName(this.resolverEndpointName).updateResolverEndpointDetails(this.updateResolverEndpointDetails).ifMatch(this.ifMatch).ifUnmodifiedSince(this.ifUnmodifiedSince).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resolverId=").append(String.valueOf(this.resolverId));
        sb.append(",resolverEndpointName=").append(String.valueOf(this.resolverEndpointName));
        sb.append(",updateResolverEndpointDetails=").append(String.valueOf((Object)this.updateResolverEndpointDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifUnmodifiedSince=").append(String.valueOf(this.ifUnmodifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateResolverEndpointRequest)) {
            return false;
        }
        UpdateResolverEndpointRequest other = (UpdateResolverEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resolverId, other.resolverId) && Objects.equals(this.resolverEndpointName, other.resolverEndpointName) && Objects.equals((Object)this.updateResolverEndpointDetails, (Object)other.updateResolverEndpointDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifUnmodifiedSince, other.ifUnmodifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resolverId == null ? 43 : this.resolverId.hashCode());
        result = result * 59 + (this.resolverEndpointName == null ? 43 : this.resolverEndpointName.hashCode());
        result = result * 59 + (this.updateResolverEndpointDetails == null ? 43 : this.updateResolverEndpointDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifUnmodifiedSince == null ? 43 : this.ifUnmodifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateResolverEndpointRequest, UpdateResolverEndpointDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resolverId = null;
        private String resolverEndpointName = null;
        private UpdateResolverEndpointDetails updateResolverEndpointDetails = null;
        private String ifMatch = null;
        private String ifUnmodifiedSince = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder resolverEndpointName(String resolverEndpointName) {
            this.resolverEndpointName = resolverEndpointName;
            return this;
        }

        public Builder updateResolverEndpointDetails(UpdateResolverEndpointDetails updateResolverEndpointDetails) {
            this.updateResolverEndpointDetails = updateResolverEndpointDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateResolverEndpointRequest o) {
            this.resolverId(o.getResolverId());
            this.resolverEndpointName(o.getResolverEndpointName());
            this.updateResolverEndpointDetails(o.getUpdateResolverEndpointDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateResolverEndpointRequest build() {
            UpdateResolverEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateResolverEndpointDetails body) {
            this.updateResolverEndpointDetails(body);
            return this;
        }

        public UpdateResolverEndpointRequest buildWithoutInvocationCallback() {
            UpdateResolverEndpointRequest request = new UpdateResolverEndpointRequest();
            request.resolverId = this.resolverId;
            request.resolverEndpointName = this.resolverEndpointName;
            request.updateResolverEndpointDetails = this.updateResolverEndpointDetails;
            request.ifMatch = this.ifMatch;
            request.ifUnmodifiedSince = this.ifUnmodifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

