/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.ResolverEndpointSummary;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListResolverEndpointsRequest
extends BmcRequest<Void> {
    private String resolverId;
    private String opcRequestId;
    private String name;
    private String page;
    private Long limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private ResolverEndpointSummary.LifecycleState lifecycleState;
    private Scope scope;

    public String getResolverId() {
        return this.resolverId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public Long getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public ResolverEndpointSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new Builder().resolverId(this.resolverId).opcRequestId(this.opcRequestId).name(this.name).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy).lifecycleState(this.lifecycleState).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resolverId=").append(String.valueOf(this.resolverId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResolverEndpointsRequest)) {
            return false;
        }
        ListResolverEndpointsRequest other = (ListResolverEndpointsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resolverId, other.resolverId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.name, other.name) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resolverId == null ? 43 : this.resolverId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResolverEndpointsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resolverId = null;
        private String opcRequestId = null;
        private String name = null;
        private String page = null;
        private Long limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private ResolverEndpointSummary.LifecycleState lifecycleState = null;
        private Scope scope = null;

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(ResolverEndpointSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResolverEndpointsRequest o) {
            this.resolverId(o.getResolverId());
            this.opcRequestId(o.getOpcRequestId());
            this.name(o.getName());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResolverEndpointsRequest build() {
            ListResolverEndpointsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListResolverEndpointsRequest buildWithoutInvocationCallback() {
            ListResolverEndpointsRequest request = new ListResolverEndpointsRequest();
            request.resolverId = this.resolverId;
            request.opcRequestId = this.opcRequestId;
            request.name = this.name;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.lifecycleState = this.lifecycleState;
            request.scope = this.scope;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("name"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

