/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRRSetRequest
extends BmcRequest<Void> {
    private String zoneNameOrId;
    private String domain;
    private String rtype;
    private String ifNoneMatch;
    private String ifModifiedSince;
    private String opcRequestId;
    private Long limit;
    private String page;
    private String zoneVersion;
    private String compartmentId;
    private Scope scope;
    private String viewId;

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRtype() {
        return this.rtype;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getZoneVersion() {
        return this.zoneVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    public Builder toBuilder() {
        return new Builder().zoneNameOrId(this.zoneNameOrId).domain(this.domain).rtype(this.rtype).ifNoneMatch(this.ifNoneMatch).ifModifiedSince(this.ifModifiedSince).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).zoneVersion(this.zoneVersion).compartmentId(this.compartmentId).scope(this.scope).viewId(this.viewId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zoneNameOrId=").append(String.valueOf(this.zoneNameOrId));
        sb.append(",domain=").append(String.valueOf(this.domain));
        sb.append(",rtype=").append(String.valueOf(this.rtype));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",ifModifiedSince=").append(String.valueOf(this.ifModifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",zoneVersion=").append(String.valueOf(this.zoneVersion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRRSetRequest)) {
            return false;
        }
        GetRRSetRequest other = (GetRRSetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zoneNameOrId, other.zoneNameOrId) && Objects.equals(this.domain, other.domain) && Objects.equals(this.rtype, other.rtype) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.ifModifiedSince, other.ifModifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.zoneVersion, other.zoneVersion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zoneNameOrId == null ? 43 : this.zoneNameOrId.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.rtype == null ? 43 : this.rtype.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.ifModifiedSince == null ? 43 : this.ifModifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.zoneVersion == null ? 43 : this.zoneVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRRSetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zoneNameOrId = null;
        private String domain = null;
        private String rtype = null;
        private String ifNoneMatch = null;
        private String ifModifiedSince = null;
        private String opcRequestId = null;
        private Long limit = null;
        private String page = null;
        private String zoneVersion = null;
        private String compartmentId = null;
        private Scope scope = null;
        private String viewId = null;

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder zoneVersion(String zoneVersion) {
            this.zoneVersion = zoneVersion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRRSetRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.rtype(o.getRtype());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.zoneVersion(o.getZoneVersion());
            this.compartmentId(o.getCompartmentId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRRSetRequest build() {
            GetRRSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRRSetRequest buildWithoutInvocationCallback() {
            GetRRSetRequest request = new GetRRSetRequest();
            request.zoneNameOrId = this.zoneNameOrId;
            request.domain = this.domain;
            request.rtype = this.rtype;
            request.ifNoneMatch = this.ifNoneMatch;
            request.ifModifiedSince = this.ifModifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.zoneVersion = this.zoneVersion;
            request.compartmentId = this.compartmentId;
            request.scope = this.scope;
            request.viewId = this.viewId;
            return request;
        }
    }
}

