/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ZoneTransferServer
extends ExplicitlySetBmcModel {
    @JsonProperty(value="address")
    private final String address;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="isTransferSource")
    private final Boolean isTransferSource;
    @JsonProperty(value="isTransferDestination")
    private final Boolean isTransferDestination;

    @Deprecated
    @ConstructorProperties(value={"address", "port", "isTransferSource", "isTransferDestination"})
    public ZoneTransferServer(String address, Integer port, Boolean isTransferSource, Boolean isTransferDestination) {
        this.address = address;
        this.port = port;
        this.isTransferSource = isTransferSource;
        this.isTransferDestination = isTransferDestination;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getIsTransferSource() {
        return this.isTransferSource;
    }

    public Boolean getIsTransferDestination() {
        return this.isTransferDestination;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ZoneTransferServer(");
        sb.append("super=").append(super.toString());
        sb.append("address=").append(String.valueOf(this.address));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", isTransferSource=").append(String.valueOf(this.isTransferSource));
        sb.append(", isTransferDestination=").append(String.valueOf(this.isTransferDestination));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneTransferServer)) {
            return false;
        }
        ZoneTransferServer other = (ZoneTransferServer)((Object)o);
        return Objects.equals(this.address, other.address) && Objects.equals(this.port, other.port) && Objects.equals(this.isTransferSource, other.isTransferSource) && Objects.equals(this.isTransferDestination, other.isTransferDestination) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.isTransferSource == null ? 43 : this.isTransferSource.hashCode());
        result = result * 59 + (this.isTransferDestination == null ? 43 : this.isTransferDestination.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="isTransferSource")
        private Boolean isTransferSource;
        @JsonProperty(value="isTransferDestination")
        private Boolean isTransferDestination;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder address(String address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder isTransferSource(Boolean isTransferSource) {
            this.isTransferSource = isTransferSource;
            this.__explicitlySet__.add("isTransferSource");
            return this;
        }

        public Builder isTransferDestination(Boolean isTransferDestination) {
            this.isTransferDestination = isTransferDestination;
            this.__explicitlySet__.add("isTransferDestination");
            return this;
        }

        public ZoneTransferServer build() {
            ZoneTransferServer model = new ZoneTransferServer(this.address, this.port, this.isTransferSource, this.isTransferDestination);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ZoneTransferServer model) {
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("isTransferSource")) {
                this.isTransferSource(model.getIsTransferSource());
            }
            if (model.wasPropertyExplicitlySet("isTransferDestination")) {
                this.isTransferDestination(model.getIsTransferDestination());
            }
            return this;
        }
    }
}

