/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.SteeringPolicyFilterRule;
import com.oracle.bmc.dns.model.SteeringPolicyHealthRule;
import com.oracle.bmc.dns.model.SteeringPolicyLimitRule;
import com.oracle.bmc.dns.model.SteeringPolicyPriorityRule;
import com.oracle.bmc.dns.model.SteeringPolicyWeightedRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType", defaultImpl=SteeringPolicyRule.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SteeringPolicyFilterRule.class, name="FILTER"), @JsonSubTypes.Type(value=SteeringPolicyWeightedRule.class, name="WEIGHTED"), @JsonSubTypes.Type(value=SteeringPolicyLimitRule.class, name="LIMIT"), @JsonSubTypes.Type(value=SteeringPolicyHealthRule.class, name="HEALTH"), @JsonSubTypes.Type(value=SteeringPolicyPriorityRule.class, name="PRIORITY")})
@JsonFilter(value="explicitlySetFilter")
public class SteeringPolicyRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"description"})
    protected SteeringPolicyRule(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SteeringPolicyRule(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SteeringPolicyRule)) {
            return false;
        }
        SteeringPolicyRule other = (SteeringPolicyRule)((Object)o);
        return Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RuleType implements BmcEnum
    {
        Filter("FILTER"),
        Health("HEALTH"),
        Weighted("WEIGHTED"),
        Priority("PRIORITY"),
        Limit("LIMIT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleType> map;

        private RuleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleType.class);
            map = new HashMap<String, RuleType>();
            for (RuleType v : RuleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

