/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.SteeringPolicyPriorityAnswerData;
import com.oracle.bmc.dns.model.SteeringPolicyPriorityRuleCase;
import com.oracle.bmc.dns.model.SteeringPolicyRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonFilter(value="explicitlySetFilter")
public final class SteeringPolicyPriorityRule
extends SteeringPolicyRule {
    @JsonProperty(value="cases")
    private final List<SteeringPolicyPriorityRuleCase> cases;
    @JsonProperty(value="defaultAnswerData")
    private final List<SteeringPolicyPriorityAnswerData> defaultAnswerData;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SteeringPolicyPriorityRule(String description, List<SteeringPolicyPriorityRuleCase> cases, List<SteeringPolicyPriorityAnswerData> defaultAnswerData) {
        super(description);
        this.cases = cases;
        this.defaultAnswerData = defaultAnswerData;
    }

    public List<SteeringPolicyPriorityRuleCase> getCases() {
        return this.cases;
    }

    public List<SteeringPolicyPriorityAnswerData> getDefaultAnswerData() {
        return this.defaultAnswerData;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SteeringPolicyPriorityRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cases=").append(String.valueOf(this.cases));
        sb.append(", defaultAnswerData=").append(String.valueOf(this.defaultAnswerData));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SteeringPolicyPriorityRule)) {
            return false;
        }
        SteeringPolicyPriorityRule other = (SteeringPolicyPriorityRule)((Object)o);
        return Objects.equals(this.cases, other.cases) && Objects.equals(this.defaultAnswerData, other.defaultAnswerData) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cases == null ? 43 : this.cases.hashCode());
        result = result * 59 + (this.defaultAnswerData == null ? 43 : this.defaultAnswerData.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="cases")
        private List<SteeringPolicyPriorityRuleCase> cases;
        @JsonProperty(value="defaultAnswerData")
        private List<SteeringPolicyPriorityAnswerData> defaultAnswerData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder cases(List<SteeringPolicyPriorityRuleCase> cases) {
            this.cases = cases;
            this.__explicitlySet__.add("cases");
            return this;
        }

        public Builder defaultAnswerData(List<SteeringPolicyPriorityAnswerData> defaultAnswerData) {
            this.defaultAnswerData = defaultAnswerData;
            this.__explicitlySet__.add("defaultAnswerData");
            return this;
        }

        public SteeringPolicyPriorityRule build() {
            SteeringPolicyPriorityRule model = new SteeringPolicyPriorityRule(this.description, this.cases, this.defaultAnswerData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SteeringPolicyPriorityRule model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("cases")) {
                this.cases(model.getCases());
            }
            if (model.wasPropertyExplicitlySet("defaultAnswerData")) {
                this.defaultAnswerData(model.getDefaultAnswerData());
            }
            return this;
        }
    }
}

