/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SteeringPolicyAttachment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="steeringPolicyId")
    private final String steeringPolicyId;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="domainName")
    private final String domainName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="rtypes")
    private final List<String> rtypes;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="self")
    private final String self;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"steeringPolicyId", "zoneId", "domainName", "displayName", "rtypes", "compartmentId", "self", "id", "timeCreated", "lifecycleState"})
    public SteeringPolicyAttachment(String steeringPolicyId, String zoneId, String domainName, String displayName, List<String> rtypes, String compartmentId, String self, String id, Date timeCreated, LifecycleState lifecycleState) {
        this.steeringPolicyId = steeringPolicyId;
        this.zoneId = zoneId;
        this.domainName = domainName;
        this.displayName = displayName;
        this.rtypes = rtypes;
        this.compartmentId = compartmentId;
        this.self = self;
        this.id = id;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSteeringPolicyId() {
        return this.steeringPolicyId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getRtypes() {
        return this.rtypes;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SteeringPolicyAttachment(");
        sb.append("super=").append(super.toString());
        sb.append("steeringPolicyId=").append(String.valueOf(this.steeringPolicyId));
        sb.append(", zoneId=").append(String.valueOf(this.zoneId));
        sb.append(", domainName=").append(String.valueOf(this.domainName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", rtypes=").append(String.valueOf(this.rtypes));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", self=").append(String.valueOf(this.self));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SteeringPolicyAttachment)) {
            return false;
        }
        SteeringPolicyAttachment other = (SteeringPolicyAttachment)((Object)o);
        return Objects.equals(this.steeringPolicyId, other.steeringPolicyId) && Objects.equals(this.zoneId, other.zoneId) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.rtypes, other.rtypes) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.self, other.self) && Objects.equals(this.id, other.id) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.steeringPolicyId == null ? 43 : this.steeringPolicyId.hashCode());
        result = result * 59 + (this.zoneId == null ? 43 : this.zoneId.hashCode());
        result = result * 59 + (this.domainName == null ? 43 : this.domainName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.rtypes == null ? 43 : this.rtypes.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.self == null ? 43 : this.self.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="steeringPolicyId")
        private String steeringPolicyId;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="domainName")
        private String domainName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="rtypes")
        private List<String> rtypes;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="self")
        private String self;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder steeringPolicyId(String steeringPolicyId) {
            this.steeringPolicyId = steeringPolicyId;
            this.__explicitlySet__.add("steeringPolicyId");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.__explicitlySet__.add("domainName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder rtypes(List<String> rtypes) {
            this.rtypes = rtypes;
            this.__explicitlySet__.add("rtypes");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.__explicitlySet__.add("self");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public SteeringPolicyAttachment build() {
            SteeringPolicyAttachment model = new SteeringPolicyAttachment(this.steeringPolicyId, this.zoneId, this.domainName, this.displayName, this.rtypes, this.compartmentId, this.self, this.id, this.timeCreated, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SteeringPolicyAttachment model) {
            if (model.wasPropertyExplicitlySet("steeringPolicyId")) {
                this.steeringPolicyId(model.getSteeringPolicyId());
            }
            if (model.wasPropertyExplicitlySet("zoneId")) {
                this.zoneId(model.getZoneId());
            }
            if (model.wasPropertyExplicitlySet("domainName")) {
                this.domainName(model.getDomainName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("rtypes")) {
                this.rtypes(model.getRtypes());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("self")) {
                this.self(model.getSelf());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

