/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.CreateResolverEndpointDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="endpointType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateResolverVnicEndpointDetails
extends CreateResolverEndpointDetails {
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateResolverVnicEndpointDetails(String name, String forwardingAddress, Boolean isForwarding, Boolean isListening, String listeningAddress, String subnetId, List<String> nsgIds) {
        super(name, forwardingAddress, isForwarding, isListening, listeningAddress);
        this.subnetId = subnetId;
        this.nsgIds = nsgIds;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateResolverVnicEndpointDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateResolverVnicEndpointDetails)) {
            return false;
        }
        CreateResolverVnicEndpointDetails other = (CreateResolverVnicEndpointDetails)((Object)o);
        return Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.nsgIds, other.nsgIds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="forwardingAddress")
        private String forwardingAddress;
        @JsonProperty(value="isForwarding")
        private Boolean isForwarding;
        @JsonProperty(value="isListening")
        private Boolean isListening;
        @JsonProperty(value="listeningAddress")
        private String listeningAddress;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder forwardingAddress(String forwardingAddress) {
            this.forwardingAddress = forwardingAddress;
            this.__explicitlySet__.add("forwardingAddress");
            return this;
        }

        public Builder isForwarding(Boolean isForwarding) {
            this.isForwarding = isForwarding;
            this.__explicitlySet__.add("isForwarding");
            return this;
        }

        public Builder isListening(Boolean isListening) {
            this.isListening = isListening;
            this.__explicitlySet__.add("isListening");
            return this;
        }

        public Builder listeningAddress(String listeningAddress) {
            this.listeningAddress = listeningAddress;
            this.__explicitlySet__.add("listeningAddress");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public CreateResolverVnicEndpointDetails build() {
            CreateResolverVnicEndpointDetails model = new CreateResolverVnicEndpointDetails(this.name, this.forwardingAddress, this.isForwarding, this.isListening, this.listeningAddress, this.subnetId, this.nsgIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateResolverVnicEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("forwardingAddress")) {
                this.forwardingAddress(model.getForwardingAddress());
            }
            if (model.wasPropertyExplicitlySet("isForwarding")) {
                this.isForwarding(model.getIsForwarding());
            }
            if (model.wasPropertyExplicitlySet("isListening")) {
                this.isListening(model.getIsListening());
            }
            if (model.wasPropertyExplicitlySet("listeningAddress")) {
                this.listeningAddress(model.getListeningAddress());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            return this;
        }
    }
}

