/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.model.Record;
import com.oracle.bmc.dns.model.ResolverEndpointSummary;
import com.oracle.bmc.dns.model.ResolverSummary;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.dns.model.SteeringPolicySummary;
import com.oracle.bmc.dns.model.TsigKeySummary;
import com.oracle.bmc.dns.model.ViewSummary;
import com.oracle.bmc.dns.model.ZoneSummary;
import com.oracle.bmc.dns.model.ZoneTransferServer;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.ListResolverEndpointsRequest;
import com.oracle.bmc.dns.requests.ListResolversRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListTsigKeysRequest;
import com.oracle.bmc.dns.requests.ListViewsRequest;
import com.oracle.bmc.dns.requests.ListZoneTransferServersRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.ListResolverEndpointsResponse;
import com.oracle.bmc.dns.responses.ListResolversResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListTsigKeysResponse;
import com.oracle.bmc.dns.responses.ListViewsResponse;
import com.oracle.bmc.dns.responses.ListZoneTransferServersResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DnsPaginators {
    private final Dns client;

    public DnsPaginators(Dns client) {
        this.client = client;
    }

    public Iterable<GetDomainRecordsResponse> getDomainRecordsResponseIterator(final GetDomainRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<GetDomainRecordsRequest.Builder>(){

            @Override
            public GetDomainRecordsRequest.Builder get() {
                return GetDomainRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetDomainRecordsResponse, String>(){

            @Override
            public String apply(GetDomainRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetDomainRecordsRequest.Builder>, GetDomainRecordsRequest>(){

            @Override
            public GetDomainRecordsRequest apply(RequestBuilderAndToken<GetDomainRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetDomainRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetDomainRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetDomainRecordsRequest, GetDomainRecordsResponse>(){

            @Override
            public GetDomainRecordsResponse apply(GetDomainRecordsRequest request) {
                return DnsPaginators.this.client.getDomainRecords(request);
            }
        });
    }

    public Iterable<Record> getDomainRecordsRecordIterator(final GetDomainRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<GetDomainRecordsRequest.Builder>(){

            @Override
            public GetDomainRecordsRequest.Builder get() {
                return GetDomainRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetDomainRecordsResponse, String>(){

            @Override
            public String apply(GetDomainRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetDomainRecordsRequest.Builder>, GetDomainRecordsRequest>(){

            @Override
            public GetDomainRecordsRequest apply(RequestBuilderAndToken<GetDomainRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetDomainRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetDomainRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetDomainRecordsRequest, GetDomainRecordsResponse>(){

            @Override
            public GetDomainRecordsResponse apply(GetDomainRecordsRequest request) {
                return DnsPaginators.this.client.getDomainRecords(request);
            }
        }, (Function)new Function<GetDomainRecordsResponse, List<Record>>(){

            @Override
            public List<Record> apply(GetDomainRecordsResponse response) {
                return response.getRecordCollection().getItems();
            }
        });
    }

    public Iterable<GetRRSetResponse> getRRSetResponseIterator(final GetRRSetRequest request) {
        return new ResponseIterable((Supplier)new Supplier<GetRRSetRequest.Builder>(){

            @Override
            public GetRRSetRequest.Builder get() {
                return GetRRSetRequest.builder().copy(request);
            }
        }, (Function)new Function<GetRRSetResponse, String>(){

            @Override
            public String apply(GetRRSetResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetRRSetRequest.Builder>, GetRRSetRequest>(){

            @Override
            public GetRRSetRequest apply(RequestBuilderAndToken<GetRRSetRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetRRSetRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetRRSetRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetRRSetRequest, GetRRSetResponse>(){

            @Override
            public GetRRSetResponse apply(GetRRSetRequest request) {
                return DnsPaginators.this.client.getRRSet(request);
            }
        });
    }

    public Iterable<Record> getRRSetRecordIterator(final GetRRSetRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<GetRRSetRequest.Builder>(){

            @Override
            public GetRRSetRequest.Builder get() {
                return GetRRSetRequest.builder().copy(request);
            }
        }, (Function)new Function<GetRRSetResponse, String>(){

            @Override
            public String apply(GetRRSetResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetRRSetRequest.Builder>, GetRRSetRequest>(){

            @Override
            public GetRRSetRequest apply(RequestBuilderAndToken<GetRRSetRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetRRSetRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetRRSetRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetRRSetRequest, GetRRSetResponse>(){

            @Override
            public GetRRSetResponse apply(GetRRSetRequest request) {
                return DnsPaginators.this.client.getRRSet(request);
            }
        }, (Function)new Function<GetRRSetResponse, List<Record>>(){

            @Override
            public List<Record> apply(GetRRSetResponse response) {
                return response.getRRSet().getItems();
            }
        });
    }

    public Iterable<GetZoneRecordsResponse> getZoneRecordsResponseIterator(final GetZoneRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<GetZoneRecordsRequest.Builder>(){

            @Override
            public GetZoneRecordsRequest.Builder get() {
                return GetZoneRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetZoneRecordsResponse, String>(){

            @Override
            public String apply(GetZoneRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetZoneRecordsRequest.Builder>, GetZoneRecordsRequest>(){

            @Override
            public GetZoneRecordsRequest apply(RequestBuilderAndToken<GetZoneRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetZoneRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetZoneRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetZoneRecordsRequest, GetZoneRecordsResponse>(){

            @Override
            public GetZoneRecordsResponse apply(GetZoneRecordsRequest request) {
                return DnsPaginators.this.client.getZoneRecords(request);
            }
        });
    }

    public Iterable<Record> getZoneRecordsRecordIterator(final GetZoneRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<GetZoneRecordsRequest.Builder>(){

            @Override
            public GetZoneRecordsRequest.Builder get() {
                return GetZoneRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetZoneRecordsResponse, String>(){

            @Override
            public String apply(GetZoneRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetZoneRecordsRequest.Builder>, GetZoneRecordsRequest>(){

            @Override
            public GetZoneRecordsRequest apply(RequestBuilderAndToken<GetZoneRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetZoneRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetZoneRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetZoneRecordsRequest, GetZoneRecordsResponse>(){

            @Override
            public GetZoneRecordsResponse apply(GetZoneRecordsRequest request) {
                return DnsPaginators.this.client.getZoneRecords(request);
            }
        }, (Function)new Function<GetZoneRecordsResponse, List<Record>>(){

            @Override
            public List<Record> apply(GetZoneRecordsResponse response) {
                return response.getRecordCollection().getItems();
            }
        });
    }

    public Iterable<ListResolverEndpointsResponse> listResolverEndpointsResponseIterator(final ListResolverEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResolverEndpointsRequest.Builder>(){

            @Override
            public ListResolverEndpointsRequest.Builder get() {
                return ListResolverEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResolverEndpointsResponse, String>(){

            @Override
            public String apply(ListResolverEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResolverEndpointsRequest.Builder>, ListResolverEndpointsRequest>(){

            @Override
            public ListResolverEndpointsRequest apply(RequestBuilderAndToken<ListResolverEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResolverEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResolverEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResolverEndpointsRequest, ListResolverEndpointsResponse>(){

            @Override
            public ListResolverEndpointsResponse apply(ListResolverEndpointsRequest request) {
                return DnsPaginators.this.client.listResolverEndpoints(request);
            }
        });
    }

    public Iterable<ResolverEndpointSummary> listResolverEndpointsRecordIterator(final ListResolverEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResolverEndpointsRequest.Builder>(){

            @Override
            public ListResolverEndpointsRequest.Builder get() {
                return ListResolverEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResolverEndpointsResponse, String>(){

            @Override
            public String apply(ListResolverEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResolverEndpointsRequest.Builder>, ListResolverEndpointsRequest>(){

            @Override
            public ListResolverEndpointsRequest apply(RequestBuilderAndToken<ListResolverEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResolverEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResolverEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResolverEndpointsRequest, ListResolverEndpointsResponse>(){

            @Override
            public ListResolverEndpointsResponse apply(ListResolverEndpointsRequest request) {
                return DnsPaginators.this.client.listResolverEndpoints(request);
            }
        }, (Function)new Function<ListResolverEndpointsResponse, List<ResolverEndpointSummary>>(){

            @Override
            public List<ResolverEndpointSummary> apply(ListResolverEndpointsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListResolversResponse> listResolversResponseIterator(final ListResolversRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResolversRequest.Builder>(){

            @Override
            public ListResolversRequest.Builder get() {
                return ListResolversRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResolversResponse, String>(){

            @Override
            public String apply(ListResolversResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResolversRequest.Builder>, ListResolversRequest>(){

            @Override
            public ListResolversRequest apply(RequestBuilderAndToken<ListResolversRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResolversRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResolversRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResolversRequest, ListResolversResponse>(){

            @Override
            public ListResolversResponse apply(ListResolversRequest request) {
                return DnsPaginators.this.client.listResolvers(request);
            }
        });
    }

    public Iterable<ResolverSummary> listResolversRecordIterator(final ListResolversRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResolversRequest.Builder>(){

            @Override
            public ListResolversRequest.Builder get() {
                return ListResolversRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResolversResponse, String>(){

            @Override
            public String apply(ListResolversResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResolversRequest.Builder>, ListResolversRequest>(){

            @Override
            public ListResolversRequest apply(RequestBuilderAndToken<ListResolversRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResolversRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResolversRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResolversRequest, ListResolversResponse>(){

            @Override
            public ListResolversResponse apply(ListResolversRequest request) {
                return DnsPaginators.this.client.listResolvers(request);
            }
        }, (Function)new Function<ListResolversResponse, List<ResolverSummary>>(){

            @Override
            public List<ResolverSummary> apply(ListResolversResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSteeringPoliciesResponse> listSteeringPoliciesResponseIterator(final ListSteeringPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSteeringPoliciesRequest.Builder>(){

            @Override
            public ListSteeringPoliciesRequest.Builder get() {
                return ListSteeringPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSteeringPoliciesResponse, String>(){

            @Override
            public String apply(ListSteeringPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder>, ListSteeringPoliciesRequest>(){

            @Override
            public ListSteeringPoliciesRequest apply(RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSteeringPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSteeringPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(){

            @Override
            public ListSteeringPoliciesResponse apply(ListSteeringPoliciesRequest request) {
                return DnsPaginators.this.client.listSteeringPolicies(request);
            }
        });
    }

    public Iterable<SteeringPolicySummary> listSteeringPoliciesRecordIterator(final ListSteeringPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSteeringPoliciesRequest.Builder>(){

            @Override
            public ListSteeringPoliciesRequest.Builder get() {
                return ListSteeringPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSteeringPoliciesResponse, String>(){

            @Override
            public String apply(ListSteeringPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder>, ListSteeringPoliciesRequest>(){

            @Override
            public ListSteeringPoliciesRequest apply(RequestBuilderAndToken<ListSteeringPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSteeringPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSteeringPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSteeringPoliciesRequest, ListSteeringPoliciesResponse>(){

            @Override
            public ListSteeringPoliciesResponse apply(ListSteeringPoliciesRequest request) {
                return DnsPaginators.this.client.listSteeringPolicies(request);
            }
        }, (Function)new Function<ListSteeringPoliciesResponse, List<SteeringPolicySummary>>(){

            @Override
            public List<SteeringPolicySummary> apply(ListSteeringPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSteeringPolicyAttachmentsResponse> listSteeringPolicyAttachmentsResponseIterator(final ListSteeringPolicyAttachmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSteeringPolicyAttachmentsRequest.Builder>(){

            @Override
            public ListSteeringPolicyAttachmentsRequest.Builder get() {
                return ListSteeringPolicyAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSteeringPolicyAttachmentsResponse, String>(){

            @Override
            public String apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder>, ListSteeringPolicyAttachmentsRequest>(){

            @Override
            public ListSteeringPolicyAttachmentsRequest apply(RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSteeringPolicyAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSteeringPolicyAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(){

            @Override
            public ListSteeringPolicyAttachmentsResponse apply(ListSteeringPolicyAttachmentsRequest request) {
                return DnsPaginators.this.client.listSteeringPolicyAttachments(request);
            }
        });
    }

    public Iterable<SteeringPolicyAttachmentSummary> listSteeringPolicyAttachmentsRecordIterator(final ListSteeringPolicyAttachmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSteeringPolicyAttachmentsRequest.Builder>(){

            @Override
            public ListSteeringPolicyAttachmentsRequest.Builder get() {
                return ListSteeringPolicyAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSteeringPolicyAttachmentsResponse, String>(){

            @Override
            public String apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder>, ListSteeringPolicyAttachmentsRequest>(){

            @Override
            public ListSteeringPolicyAttachmentsRequest apply(RequestBuilderAndToken<ListSteeringPolicyAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSteeringPolicyAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSteeringPolicyAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSteeringPolicyAttachmentsRequest, ListSteeringPolicyAttachmentsResponse>(){

            @Override
            public ListSteeringPolicyAttachmentsResponse apply(ListSteeringPolicyAttachmentsRequest request) {
                return DnsPaginators.this.client.listSteeringPolicyAttachments(request);
            }
        }, (Function)new Function<ListSteeringPolicyAttachmentsResponse, List<SteeringPolicyAttachmentSummary>>(){

            @Override
            public List<SteeringPolicyAttachmentSummary> apply(ListSteeringPolicyAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTsigKeysResponse> listTsigKeysResponseIterator(final ListTsigKeysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTsigKeysRequest.Builder>(){

            @Override
            public ListTsigKeysRequest.Builder get() {
                return ListTsigKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTsigKeysResponse, String>(){

            @Override
            public String apply(ListTsigKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTsigKeysRequest.Builder>, ListTsigKeysRequest>(){

            @Override
            public ListTsigKeysRequest apply(RequestBuilderAndToken<ListTsigKeysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTsigKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTsigKeysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTsigKeysRequest, ListTsigKeysResponse>(){

            @Override
            public ListTsigKeysResponse apply(ListTsigKeysRequest request) {
                return DnsPaginators.this.client.listTsigKeys(request);
            }
        });
    }

    public Iterable<TsigKeySummary> listTsigKeysRecordIterator(final ListTsigKeysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTsigKeysRequest.Builder>(){

            @Override
            public ListTsigKeysRequest.Builder get() {
                return ListTsigKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTsigKeysResponse, String>(){

            @Override
            public String apply(ListTsigKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTsigKeysRequest.Builder>, ListTsigKeysRequest>(){

            @Override
            public ListTsigKeysRequest apply(RequestBuilderAndToken<ListTsigKeysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTsigKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTsigKeysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTsigKeysRequest, ListTsigKeysResponse>(){

            @Override
            public ListTsigKeysResponse apply(ListTsigKeysRequest request) {
                return DnsPaginators.this.client.listTsigKeys(request);
            }
        }, (Function)new Function<ListTsigKeysResponse, List<TsigKeySummary>>(){

            @Override
            public List<TsigKeySummary> apply(ListTsigKeysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListViewsResponse> listViewsResponseIterator(final ListViewsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListViewsRequest.Builder>(){

            @Override
            public ListViewsRequest.Builder get() {
                return ListViewsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListViewsResponse, String>(){

            @Override
            public String apply(ListViewsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListViewsRequest.Builder>, ListViewsRequest>(){

            @Override
            public ListViewsRequest apply(RequestBuilderAndToken<ListViewsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListViewsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListViewsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListViewsRequest, ListViewsResponse>(){

            @Override
            public ListViewsResponse apply(ListViewsRequest request) {
                return DnsPaginators.this.client.listViews(request);
            }
        });
    }

    public Iterable<ViewSummary> listViewsRecordIterator(final ListViewsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListViewsRequest.Builder>(){

            @Override
            public ListViewsRequest.Builder get() {
                return ListViewsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListViewsResponse, String>(){

            @Override
            public String apply(ListViewsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListViewsRequest.Builder>, ListViewsRequest>(){

            @Override
            public ListViewsRequest apply(RequestBuilderAndToken<ListViewsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListViewsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListViewsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListViewsRequest, ListViewsResponse>(){

            @Override
            public ListViewsResponse apply(ListViewsRequest request) {
                return DnsPaginators.this.client.listViews(request);
            }
        }, (Function)new Function<ListViewsResponse, List<ViewSummary>>(){

            @Override
            public List<ViewSummary> apply(ListViewsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListZoneTransferServersResponse> listZoneTransferServersResponseIterator(final ListZoneTransferServersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListZoneTransferServersRequest.Builder>(){

            @Override
            public ListZoneTransferServersRequest.Builder get() {
                return ListZoneTransferServersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListZoneTransferServersResponse, String>(){

            @Override
            public String apply(ListZoneTransferServersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListZoneTransferServersRequest.Builder>, ListZoneTransferServersRequest>(){

            @Override
            public ListZoneTransferServersRequest apply(RequestBuilderAndToken<ListZoneTransferServersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListZoneTransferServersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListZoneTransferServersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListZoneTransferServersRequest, ListZoneTransferServersResponse>(){

            @Override
            public ListZoneTransferServersResponse apply(ListZoneTransferServersRequest request) {
                return DnsPaginators.this.client.listZoneTransferServers(request);
            }
        });
    }

    public Iterable<ZoneTransferServer> listZoneTransferServersRecordIterator(final ListZoneTransferServersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListZoneTransferServersRequest.Builder>(){

            @Override
            public ListZoneTransferServersRequest.Builder get() {
                return ListZoneTransferServersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListZoneTransferServersResponse, String>(){

            @Override
            public String apply(ListZoneTransferServersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListZoneTransferServersRequest.Builder>, ListZoneTransferServersRequest>(){

            @Override
            public ListZoneTransferServersRequest apply(RequestBuilderAndToken<ListZoneTransferServersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListZoneTransferServersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListZoneTransferServersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListZoneTransferServersRequest, ListZoneTransferServersResponse>(){

            @Override
            public ListZoneTransferServersResponse apply(ListZoneTransferServersRequest request) {
                return DnsPaginators.this.client.listZoneTransferServers(request);
            }
        }, (Function)new Function<ListZoneTransferServersResponse, List<ZoneTransferServer>>(){

            @Override
            public List<ZoneTransferServer> apply(ListZoneTransferServersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListZonesResponse> listZonesResponseIterator(final ListZonesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListZonesRequest.Builder>(){

            @Override
            public ListZonesRequest.Builder get() {
                return ListZonesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListZonesResponse, String>(){

            @Override
            public String apply(ListZonesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListZonesRequest.Builder>, ListZonesRequest>(){

            @Override
            public ListZonesRequest apply(RequestBuilderAndToken<ListZonesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListZonesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListZonesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListZonesRequest, ListZonesResponse>(){

            @Override
            public ListZonesResponse apply(ListZonesRequest request) {
                return DnsPaginators.this.client.listZones(request);
            }
        });
    }

    public Iterable<ZoneSummary> listZonesRecordIterator(final ListZonesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListZonesRequest.Builder>(){

            @Override
            public ListZonesRequest.Builder get() {
                return ListZonesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListZonesResponse, String>(){

            @Override
            public String apply(ListZonesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListZonesRequest.Builder>, ListZonesRequest>(){

            @Override
            public ListZonesRequest apply(RequestBuilderAndToken<ListZonesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListZonesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListZonesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListZonesRequest, ListZonesResponse>(){

            @Override
            public ListZonesResponse apply(ListZonesRequest request) {
                return DnsPaginators.this.client.listZones(request);
            }
        }, (Function)new Function<ListZonesResponse, List<ZoneSummary>>(){

            @Override
            public List<ZoneSummary> apply(ListZonesResponse response) {
                return response.getItems();
            }
        });
    }
}

