/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.ChangeProjectCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeProjectCompartmentRequest
extends BmcRequest<ChangeProjectCompartmentDetails> {
    private String projectId;
    private ChangeProjectCompartmentDetails changeProjectCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getProjectId() {
        return this.projectId;
    }

    public ChangeProjectCompartmentDetails getChangeProjectCompartmentDetails() {
        return this.changeProjectCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeProjectCompartmentDetails getBody$() {
        return this.changeProjectCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().projectId(this.projectId).changeProjectCompartmentDetails(this.changeProjectCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",projectId=").append(String.valueOf(this.projectId));
        sb.append(",changeProjectCompartmentDetails=").append(String.valueOf((Object)this.changeProjectCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeProjectCompartmentRequest)) {
            return false;
        }
        ChangeProjectCompartmentRequest other = (ChangeProjectCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.projectId, other.projectId) && Objects.equals((Object)this.changeProjectCompartmentDetails, (Object)other.changeProjectCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.changeProjectCompartmentDetails == null ? 43 : this.changeProjectCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeProjectCompartmentRequest, ChangeProjectCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String projectId = null;
        private ChangeProjectCompartmentDetails changeProjectCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder changeProjectCompartmentDetails(ChangeProjectCompartmentDetails changeProjectCompartmentDetails) {
            this.changeProjectCompartmentDetails = changeProjectCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeProjectCompartmentRequest o) {
            this.projectId(o.getProjectId());
            this.changeProjectCompartmentDetails(o.getChangeProjectCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeProjectCompartmentRequest build() {
            ChangeProjectCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeProjectCompartmentDetails body) {
            this.changeProjectCompartmentDetails(body);
            return this;
        }

        public ChangeProjectCompartmentRequest buildWithoutInvocationCallback() {
            ChangeProjectCompartmentRequest request = new ChangeProjectCompartmentRequest();
            request.projectId = this.projectId;
            request.changeProjectCompartmentDetails = this.changeProjectCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

