/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.NotebookSessionShapeSeries;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NotebookSessionShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="coreCount")
    private final Integer coreCount;
    @JsonProperty(value="memoryInGBs")
    private final Integer memoryInGBs;
    @JsonProperty(value="shapeSeries")
    private final NotebookSessionShapeSeries shapeSeries;

    @Deprecated
    @ConstructorProperties(value={"name", "coreCount", "memoryInGBs", "shapeSeries"})
    public NotebookSessionShapeSummary(String name, Integer coreCount, Integer memoryInGBs, NotebookSessionShapeSeries shapeSeries) {
        this.name = name;
        this.coreCount = coreCount;
        this.memoryInGBs = memoryInGBs;
        this.shapeSeries = shapeSeries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getCoreCount() {
        return this.coreCount;
    }

    public Integer getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public NotebookSessionShapeSeries getShapeSeries() {
        return this.shapeSeries;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NotebookSessionShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", coreCount=").append(String.valueOf(this.coreCount));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", shapeSeries=").append(String.valueOf((Object)this.shapeSeries));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotebookSessionShapeSummary)) {
            return false;
        }
        NotebookSessionShapeSummary other = (NotebookSessionShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.coreCount, other.coreCount) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.shapeSeries, (Object)other.shapeSeries) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.coreCount == null ? 43 : this.coreCount.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.shapeSeries == null ? 43 : this.shapeSeries.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="coreCount")
        private Integer coreCount;
        @JsonProperty(value="memoryInGBs")
        private Integer memoryInGBs;
        @JsonProperty(value="shapeSeries")
        private NotebookSessionShapeSeries shapeSeries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            this.__explicitlySet__.add("coreCount");
            return this;
        }

        public Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder shapeSeries(NotebookSessionShapeSeries shapeSeries) {
            this.shapeSeries = shapeSeries;
            this.__explicitlySet__.add("shapeSeries");
            return this;
        }

        public NotebookSessionShapeSummary build() {
            NotebookSessionShapeSummary model = new NotebookSessionShapeSummary(this.name, this.coreCount, this.memoryInGBs, this.shapeSeries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NotebookSessionShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("coreCount")) {
                this.coreCount(model.getCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("shapeSeries")) {
                this.shapeSeries(model.getShapeSeries());
            }
            return this;
        }
    }
}

