/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.RunSecurityAssessmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RefreshSecurityAssessmentRequest
extends BmcRequest<RunSecurityAssessmentDetails> {
    private String securityAssessmentId;
    private RunSecurityAssessmentDetails runSecurityAssessmentDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getSecurityAssessmentId() {
        return this.securityAssessmentId;
    }

    public RunSecurityAssessmentDetails getRunSecurityAssessmentDetails() {
        return this.runSecurityAssessmentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public RunSecurityAssessmentDetails getBody$() {
        return this.runSecurityAssessmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().securityAssessmentId(this.securityAssessmentId).runSecurityAssessmentDetails(this.runSecurityAssessmentDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAssessmentId=").append(String.valueOf(this.securityAssessmentId));
        sb.append(",runSecurityAssessmentDetails=").append(String.valueOf((Object)this.runSecurityAssessmentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefreshSecurityAssessmentRequest)) {
            return false;
        }
        RefreshSecurityAssessmentRequest other = (RefreshSecurityAssessmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAssessmentId, other.securityAssessmentId) && Objects.equals((Object)this.runSecurityAssessmentDetails, (Object)other.runSecurityAssessmentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAssessmentId == null ? 43 : this.securityAssessmentId.hashCode());
        result = result * 59 + (this.runSecurityAssessmentDetails == null ? 43 : this.runSecurityAssessmentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RefreshSecurityAssessmentRequest, RunSecurityAssessmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAssessmentId = null;
        private RunSecurityAssessmentDetails runSecurityAssessmentDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder securityAssessmentId(String securityAssessmentId) {
            this.securityAssessmentId = securityAssessmentId;
            return this;
        }

        public Builder runSecurityAssessmentDetails(RunSecurityAssessmentDetails runSecurityAssessmentDetails) {
            this.runSecurityAssessmentDetails = runSecurityAssessmentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RefreshSecurityAssessmentRequest o) {
            this.securityAssessmentId(o.getSecurityAssessmentId());
            this.runSecurityAssessmentDetails(o.getRunSecurityAssessmentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RefreshSecurityAssessmentRequest build() {
            RefreshSecurityAssessmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RunSecurityAssessmentDetails body) {
            this.runSecurityAssessmentDetails(body);
            return this;
        }

        public RefreshSecurityAssessmentRequest buildWithoutInvocationCallback() {
            RefreshSecurityAssessmentRequest request = new RefreshSecurityAssessmentRequest();
            request.securityAssessmentId = this.securityAssessmentId;
            request.runSecurityAssessmentDetails = this.runSecurityAssessmentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

