/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetUserAssessmentComparisonRequest
extends BmcRequest<Void> {
    private String userAssessmentId;
    private String comparisonUserAssessmentId;
    private String opcRequestId;

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public String getComparisonUserAssessmentId() {
        return this.comparisonUserAssessmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().userAssessmentId(this.userAssessmentId).comparisonUserAssessmentId(this.comparisonUserAssessmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(",comparisonUserAssessmentId=").append(String.valueOf(this.comparisonUserAssessmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUserAssessmentComparisonRequest)) {
            return false;
        }
        GetUserAssessmentComparisonRequest other = (GetUserAssessmentComparisonRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.comparisonUserAssessmentId, other.comparisonUserAssessmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.comparisonUserAssessmentId == null ? 43 : this.comparisonUserAssessmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUserAssessmentComparisonRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userAssessmentId = null;
        private String comparisonUserAssessmentId = null;
        private String opcRequestId = null;

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            return this;
        }

        public Builder comparisonUserAssessmentId(String comparisonUserAssessmentId) {
            this.comparisonUserAssessmentId = comparisonUserAssessmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUserAssessmentComparisonRequest o) {
            this.userAssessmentId(o.getUserAssessmentId());
            this.comparisonUserAssessmentId(o.getComparisonUserAssessmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUserAssessmentComparisonRequest build() {
            GetUserAssessmentComparisonRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetUserAssessmentComparisonRequest buildWithoutInvocationCallback() {
            GetUserAssessmentComparisonRequest request = new GetUserAssessmentComparisonRequest();
            request.userAssessmentId = this.userAssessmentId;
            request.comparisonUserAssessmentId = this.comparisonUserAssessmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

