/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOnPremConnectorRequest
extends BmcRequest<Void> {
    private String onPremConnectorId;
    private String opcRequestId;

    public String getOnPremConnectorId() {
        return this.onPremConnectorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().onPremConnectorId(this.onPremConnectorId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",onPremConnectorId=").append(String.valueOf(this.onPremConnectorId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOnPremConnectorRequest)) {
            return false;
        }
        GetOnPremConnectorRequest other = (GetOnPremConnectorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.onPremConnectorId, other.onPremConnectorId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.onPremConnectorId == null ? 43 : this.onPremConnectorId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOnPremConnectorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String onPremConnectorId = null;
        private String opcRequestId = null;

        public Builder onPremConnectorId(String onPremConnectorId) {
            this.onPremConnectorId = onPremConnectorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOnPremConnectorRequest o) {
            this.onPremConnectorId(o.getOnPremConnectorId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOnPremConnectorRequest build() {
            GetOnPremConnectorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOnPremConnectorRequest buildWithoutInvocationCallback() {
            GetOnPremConnectorRequest request = new GetOnPremConnectorRequest();
            request.onPremConnectorId = this.onPremConnectorId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

