/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.DownloadSensitiveDataModelDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DownloadSensitiveDataModelRequest
extends BmcRequest<DownloadSensitiveDataModelDetails> {
    private String sensitiveDataModelId;
    private DownloadSensitiveDataModelDetails downloadSensitiveDataModelDetails;
    private String opcRequestId;

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public DownloadSensitiveDataModelDetails getDownloadSensitiveDataModelDetails() {
        return this.downloadSensitiveDataModelDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DownloadSensitiveDataModelDetails getBody$() {
        return this.downloadSensitiveDataModelDetails;
    }

    public Builder toBuilder() {
        return new Builder().sensitiveDataModelId(this.sensitiveDataModelId).downloadSensitiveDataModelDetails(this.downloadSensitiveDataModelDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(",downloadSensitiveDataModelDetails=").append(String.valueOf((Object)this.downloadSensitiveDataModelDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadSensitiveDataModelRequest)) {
            return false;
        }
        DownloadSensitiveDataModelRequest other = (DownloadSensitiveDataModelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals((Object)this.downloadSensitiveDataModelDetails, (Object)other.downloadSensitiveDataModelDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.downloadSensitiveDataModelDetails == null ? 43 : this.downloadSensitiveDataModelDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DownloadSensitiveDataModelRequest, DownloadSensitiveDataModelDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sensitiveDataModelId = null;
        private DownloadSensitiveDataModelDetails downloadSensitiveDataModelDetails = null;
        private String opcRequestId = null;

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            return this;
        }

        public Builder downloadSensitiveDataModelDetails(DownloadSensitiveDataModelDetails downloadSensitiveDataModelDetails) {
            this.downloadSensitiveDataModelDetails = downloadSensitiveDataModelDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DownloadSensitiveDataModelRequest o) {
            this.sensitiveDataModelId(o.getSensitiveDataModelId());
            this.downloadSensitiveDataModelDetails(o.getDownloadSensitiveDataModelDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DownloadSensitiveDataModelRequest build() {
            DownloadSensitiveDataModelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DownloadSensitiveDataModelDetails body) {
            this.downloadSensitiveDataModelDetails(body);
            return this;
        }

        public DownloadSensitiveDataModelRequest buildWithoutInvocationCallback() {
            DownloadSensitiveDataModelRequest request = new DownloadSensitiveDataModelRequest();
            request.sensitiveDataModelId = this.sensitiveDataModelId;
            request.downloadSensitiveDataModelDetails = this.downloadSensitiveDataModelDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

