/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.DownloadMaskingReportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DownloadMaskingReportRequest
extends BmcRequest<DownloadMaskingReportDetails> {
    private String maskingPolicyId;
    private DownloadMaskingReportDetails downloadMaskingReportDetails;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public DownloadMaskingReportDetails getDownloadMaskingReportDetails() {
        return this.downloadMaskingReportDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DownloadMaskingReportDetails getBody$() {
        return this.downloadMaskingReportDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).downloadMaskingReportDetails(this.downloadMaskingReportDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",downloadMaskingReportDetails=").append(String.valueOf((Object)this.downloadMaskingReportDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadMaskingReportRequest)) {
            return false;
        }
        DownloadMaskingReportRequest other = (DownloadMaskingReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.downloadMaskingReportDetails, (Object)other.downloadMaskingReportDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.downloadMaskingReportDetails == null ? 43 : this.downloadMaskingReportDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DownloadMaskingReportRequest, DownloadMaskingReportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private DownloadMaskingReportDetails downloadMaskingReportDetails = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder downloadMaskingReportDetails(DownloadMaskingReportDetails downloadMaskingReportDetails) {
            this.downloadMaskingReportDetails = downloadMaskingReportDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DownloadMaskingReportRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.downloadMaskingReportDetails(o.getDownloadMaskingReportDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DownloadMaskingReportRequest build() {
            DownloadMaskingReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DownloadMaskingReportDetails body) {
            this.downloadMaskingReportDetails(body);
            return this;
        }

        public DownloadMaskingReportRequest buildWithoutInvocationCallback() {
            DownloadMaskingReportRequest request = new DownloadMaskingReportRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.downloadMaskingReportDetails = this.downloadMaskingReportDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

