/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.DownloadMaskingLogDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DownloadMaskingLogRequest
extends BmcRequest<DownloadMaskingLogDetails> {
    private String maskingPolicyId;
    private DownloadMaskingLogDetails downloadMaskingLogDetails;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public DownloadMaskingLogDetails getDownloadMaskingLogDetails() {
        return this.downloadMaskingLogDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DownloadMaskingLogDetails getBody$() {
        return this.downloadMaskingLogDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).downloadMaskingLogDetails(this.downloadMaskingLogDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",downloadMaskingLogDetails=").append(String.valueOf((Object)this.downloadMaskingLogDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadMaskingLogRequest)) {
            return false;
        }
        DownloadMaskingLogRequest other = (DownloadMaskingLogRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.downloadMaskingLogDetails, (Object)other.downloadMaskingLogDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.downloadMaskingLogDetails == null ? 43 : this.downloadMaskingLogDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DownloadMaskingLogRequest, DownloadMaskingLogDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private DownloadMaskingLogDetails downloadMaskingLogDetails = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder downloadMaskingLogDetails(DownloadMaskingLogDetails downloadMaskingLogDetails) {
            this.downloadMaskingLogDetails = downloadMaskingLogDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DownloadMaskingLogRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.downloadMaskingLogDetails(o.getDownloadMaskingLogDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DownloadMaskingLogRequest build() {
            DownloadMaskingLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DownloadMaskingLogDetails body) {
            this.downloadMaskingLogDetails(body);
            return this;
        }

        public DownloadMaskingLogRequest buildWithoutInvocationCallback() {
            DownloadMaskingLogRequest request = new DownloadMaskingLogRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.downloadMaskingLogDetails = this.downloadMaskingLogDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

