/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDiscoveryJobResultRequest
extends BmcRequest<Void> {
    private String discoveryJobId;
    private String resultKey;
    private String ifMatch;
    private String opcRequestId;

    public String getDiscoveryJobId() {
        return this.discoveryJobId;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().discoveryJobId(this.discoveryJobId).resultKey(this.resultKey).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",discoveryJobId=").append(String.valueOf(this.discoveryJobId));
        sb.append(",resultKey=").append(String.valueOf(this.resultKey));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDiscoveryJobResultRequest)) {
            return false;
        }
        DeleteDiscoveryJobResultRequest other = (DeleteDiscoveryJobResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.discoveryJobId, other.discoveryJobId) && Objects.equals(this.resultKey, other.resultKey) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.discoveryJobId == null ? 43 : this.discoveryJobId.hashCode());
        result = result * 59 + (this.resultKey == null ? 43 : this.resultKey.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDiscoveryJobResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String discoveryJobId = null;
        private String resultKey = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder discoveryJobId(String discoveryJobId) {
            this.discoveryJobId = discoveryJobId;
            return this;
        }

        public Builder resultKey(String resultKey) {
            this.resultKey = resultKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDiscoveryJobResultRequest o) {
            this.discoveryJobId(o.getDiscoveryJobId());
            this.resultKey(o.getResultKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDiscoveryJobResultRequest build() {
            DeleteDiscoveryJobResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDiscoveryJobResultRequest buildWithoutInvocationCallback() {
            DeleteDiscoveryJobResultRequest request = new DeleteDiscoveryJobResultRequest();
            request.discoveryJobId = this.discoveryJobId;
            request.resultKey = this.resultKey;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

