/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UserSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="userCategory")
    private final UserCategory userCategory;
    @JsonProperty(value="accountStatus")
    private final AccountStatus accountStatus;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="timeLastLogin")
    private final Date timeLastLogin;
    @JsonProperty(value="timeUserCreated")
    private final Date timeUserCreated;
    @JsonProperty(value="authenticationType")
    private final AuthenticationType authenticationType;
    @JsonProperty(value="userProfile")
    private final String userProfile;
    @JsonProperty(value="timePasswordChanged")
    private final Date timePasswordChanged;
    @JsonProperty(value="userTypes")
    private final List<UserTypes> userTypes;
    @JsonProperty(value="adminRoles")
    private final List<AdminRoles> adminRoles;

    @Deprecated
    @ConstructorProperties(value={"key", "userName", "userCategory", "accountStatus", "targetId", "timeLastLogin", "timeUserCreated", "authenticationType", "userProfile", "timePasswordChanged", "userTypes", "adminRoles"})
    public UserSummary(String key, String userName, UserCategory userCategory, AccountStatus accountStatus, String targetId, Date timeLastLogin, Date timeUserCreated, AuthenticationType authenticationType, String userProfile, Date timePasswordChanged, List<UserTypes> userTypes, List<AdminRoles> adminRoles) {
        this.key = key;
        this.userName = userName;
        this.userCategory = userCategory;
        this.accountStatus = accountStatus;
        this.targetId = targetId;
        this.timeLastLogin = timeLastLogin;
        this.timeUserCreated = timeUserCreated;
        this.authenticationType = authenticationType;
        this.userProfile = userProfile;
        this.timePasswordChanged = timePasswordChanged;
        this.userTypes = userTypes;
        this.adminRoles = adminRoles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getUserName() {
        return this.userName;
    }

    public UserCategory getUserCategory() {
        return this.userCategory;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Date getTimeLastLogin() {
        return this.timeLastLogin;
    }

    public Date getTimeUserCreated() {
        return this.timeUserCreated;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getUserProfile() {
        return this.userProfile;
    }

    public Date getTimePasswordChanged() {
        return this.timePasswordChanged;
    }

    public List<UserTypes> getUserTypes() {
        return this.userTypes;
    }

    public List<AdminRoles> getAdminRoles() {
        return this.adminRoles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UserSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", userCategory=").append(String.valueOf((Object)this.userCategory));
        sb.append(", accountStatus=").append(String.valueOf((Object)this.accountStatus));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", timeLastLogin=").append(String.valueOf(this.timeLastLogin));
        sb.append(", timeUserCreated=").append(String.valueOf(this.timeUserCreated));
        sb.append(", authenticationType=").append(String.valueOf((Object)this.authenticationType));
        sb.append(", userProfile=").append(String.valueOf(this.userProfile));
        sb.append(", timePasswordChanged=").append(String.valueOf(this.timePasswordChanged));
        sb.append(", userTypes=").append(String.valueOf(this.userTypes));
        sb.append(", adminRoles=").append(String.valueOf(this.adminRoles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.userCategory, (Object)other.userCategory) && Objects.equals((Object)this.accountStatus, (Object)other.accountStatus) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.timeLastLogin, other.timeLastLogin) && Objects.equals(this.timeUserCreated, other.timeUserCreated) && Objects.equals((Object)this.authenticationType, (Object)other.authenticationType) && Objects.equals(this.userProfile, other.userProfile) && Objects.equals(this.timePasswordChanged, other.timePasswordChanged) && Objects.equals(this.userTypes, other.userTypes) && Objects.equals(this.adminRoles, other.adminRoles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.userCategory == null ? 43 : this.userCategory.hashCode());
        result = result * 59 + (this.accountStatus == null ? 43 : this.accountStatus.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.timeLastLogin == null ? 43 : this.timeLastLogin.hashCode());
        result = result * 59 + (this.timeUserCreated == null ? 43 : this.timeUserCreated.hashCode());
        result = result * 59 + (this.authenticationType == null ? 43 : this.authenticationType.hashCode());
        result = result * 59 + (this.userProfile == null ? 43 : this.userProfile.hashCode());
        result = result * 59 + (this.timePasswordChanged == null ? 43 : this.timePasswordChanged.hashCode());
        result = result * 59 + (this.userTypes == null ? 43 : this.userTypes.hashCode());
        result = result * 59 + (this.adminRoles == null ? 43 : this.adminRoles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AdminRoles implements BmcEnum
    {
        PdbDba("PDB_DBA"),
        Dba("DBA"),
        DvAdmin("DV_ADMIN"),
        AuditAdmin("AUDIT_ADMIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AdminRoles> map;

        private AdminRoles(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AdminRoles create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AdminRoles', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AdminRoles.class);
            map = new HashMap<String, AdminRoles>();
            for (AdminRoles v : AdminRoles.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UserTypes implements BmcEnum
    {
        AdminPrivileged("ADMIN_PRIVILEGED"),
        Application("APPLICATION"),
        Privileged("PRIVILEGED"),
        Schema("SCHEMA"),
        NonPrivileged("NON_PRIVILEGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UserTypes> map;

        private UserTypes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UserTypes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UserTypes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UserTypes.class);
            map = new HashMap<String, UserTypes>();
            for (UserTypes v : UserTypes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuthenticationType implements BmcEnum
    {
        Password("PASSWORD"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuthenticationType> map;

        private AuthenticationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuthenticationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuthenticationType.class);
            map = new HashMap<String, AuthenticationType>();
            for (AuthenticationType v : AuthenticationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccountStatus implements BmcEnum
    {
        Open("OPEN"),
        Locked("LOCKED"),
        Expired("EXPIRED"),
        ExpiredAndLocked("EXPIRED_AND_LOCKED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AccountStatus> map;

        private AccountStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccountStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AccountStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AccountStatus.class);
            map = new HashMap<String, AccountStatus>();
            for (AccountStatus v : AccountStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UserCategory implements BmcEnum
    {
        Critical("CRITICAL"),
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UserCategory> map;

        private UserCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UserCategory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UserCategory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UserCategory.class);
            map = new HashMap<String, UserCategory>();
            for (UserCategory v : UserCategory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="userCategory")
        private UserCategory userCategory;
        @JsonProperty(value="accountStatus")
        private AccountStatus accountStatus;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="timeLastLogin")
        private Date timeLastLogin;
        @JsonProperty(value="timeUserCreated")
        private Date timeUserCreated;
        @JsonProperty(value="authenticationType")
        private AuthenticationType authenticationType;
        @JsonProperty(value="userProfile")
        private String userProfile;
        @JsonProperty(value="timePasswordChanged")
        private Date timePasswordChanged;
        @JsonProperty(value="userTypes")
        private List<UserTypes> userTypes;
        @JsonProperty(value="adminRoles")
        private List<AdminRoles> adminRoles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder userCategory(UserCategory userCategory) {
            this.userCategory = userCategory;
            this.__explicitlySet__.add("userCategory");
            return this;
        }

        public Builder accountStatus(AccountStatus accountStatus) {
            this.accountStatus = accountStatus;
            this.__explicitlySet__.add("accountStatus");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder timeLastLogin(Date timeLastLogin) {
            this.timeLastLogin = timeLastLogin;
            this.__explicitlySet__.add("timeLastLogin");
            return this;
        }

        public Builder timeUserCreated(Date timeUserCreated) {
            this.timeUserCreated = timeUserCreated;
            this.__explicitlySet__.add("timeUserCreated");
            return this;
        }

        public Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.__explicitlySet__.add("authenticationType");
            return this;
        }

        public Builder userProfile(String userProfile) {
            this.userProfile = userProfile;
            this.__explicitlySet__.add("userProfile");
            return this;
        }

        public Builder timePasswordChanged(Date timePasswordChanged) {
            this.timePasswordChanged = timePasswordChanged;
            this.__explicitlySet__.add("timePasswordChanged");
            return this;
        }

        public Builder userTypes(List<UserTypes> userTypes) {
            this.userTypes = userTypes;
            this.__explicitlySet__.add("userTypes");
            return this;
        }

        public Builder adminRoles(List<AdminRoles> adminRoles) {
            this.adminRoles = adminRoles;
            this.__explicitlySet__.add("adminRoles");
            return this;
        }

        public UserSummary build() {
            UserSummary model = new UserSummary(this.key, this.userName, this.userCategory, this.accountStatus, this.targetId, this.timeLastLogin, this.timeUserCreated, this.authenticationType, this.userProfile, this.timePasswordChanged, this.userTypes, this.adminRoles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UserSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("userCategory")) {
                this.userCategory(model.getUserCategory());
            }
            if (model.wasPropertyExplicitlySet("accountStatus")) {
                this.accountStatus(model.getAccountStatus());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("timeLastLogin")) {
                this.timeLastLogin(model.getTimeLastLogin());
            }
            if (model.wasPropertyExplicitlySet("timeUserCreated")) {
                this.timeUserCreated(model.getTimeUserCreated());
            }
            if (model.wasPropertyExplicitlySet("authenticationType")) {
                this.authenticationType(model.getAuthenticationType());
            }
            if (model.wasPropertyExplicitlySet("userProfile")) {
                this.userProfile(model.getUserProfile());
            }
            if (model.wasPropertyExplicitlySet("timePasswordChanged")) {
                this.timePasswordChanged(model.getTimePasswordChanged());
            }
            if (model.wasPropertyExplicitlySet("userTypes")) {
                this.userTypes(model.getUserTypes());
            }
            if (model.wasPropertyExplicitlySet("adminRoles")) {
                this.adminRoles(model.getAdminRoles());
            }
            return this;
        }
    }
}

