/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.SensitiveTypePattern;
import com.oracle.bmc.datasafe.model.UpdateSensitiveTypeDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateSensitiveTypePatternDetails
extends UpdateSensitiveTypeDetails {
    @JsonProperty(value="namePattern")
    private final String namePattern;
    @JsonProperty(value="commentPattern")
    private final String commentPattern;
    @JsonProperty(value="dataPattern")
    private final String dataPattern;
    @JsonProperty(value="searchType")
    private final SensitiveTypePattern.SearchType searchType;
    @JsonProperty(value="defaultMaskingFormatId")
    private final String defaultMaskingFormatId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateSensitiveTypePatternDetails(String displayName, String shortName, String description, String parentCategoryId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String namePattern, String commentPattern, String dataPattern, SensitiveTypePattern.SearchType searchType, String defaultMaskingFormatId) {
        super(displayName, shortName, description, parentCategoryId, freeformTags, definedTags);
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.dataPattern = dataPattern;
        this.searchType = searchType;
        this.defaultMaskingFormatId = defaultMaskingFormatId;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public String getDataPattern() {
        return this.dataPattern;
    }

    public SensitiveTypePattern.SearchType getSearchType() {
        return this.searchType;
    }

    public String getDefaultMaskingFormatId() {
        return this.defaultMaskingFormatId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSensitiveTypePatternDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namePattern=").append(String.valueOf(this.namePattern));
        sb.append(", commentPattern=").append(String.valueOf(this.commentPattern));
        sb.append(", dataPattern=").append(String.valueOf(this.dataPattern));
        sb.append(", searchType=").append(String.valueOf((Object)this.searchType));
        sb.append(", defaultMaskingFormatId=").append(String.valueOf(this.defaultMaskingFormatId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSensitiveTypePatternDetails)) {
            return false;
        }
        UpdateSensitiveTypePatternDetails other = (UpdateSensitiveTypePatternDetails)((Object)o);
        return Objects.equals(this.namePattern, other.namePattern) && Objects.equals(this.commentPattern, other.commentPattern) && Objects.equals(this.dataPattern, other.dataPattern) && Objects.equals((Object)this.searchType, (Object)other.searchType) && Objects.equals(this.defaultMaskingFormatId, other.defaultMaskingFormatId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namePattern == null ? 43 : this.namePattern.hashCode());
        result = result * 59 + (this.commentPattern == null ? 43 : this.commentPattern.hashCode());
        result = result * 59 + (this.dataPattern == null ? 43 : this.dataPattern.hashCode());
        result = result * 59 + (this.searchType == null ? 43 : this.searchType.hashCode());
        result = result * 59 + (this.defaultMaskingFormatId == null ? 43 : this.defaultMaskingFormatId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="shortName")
        private String shortName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parentCategoryId")
        private String parentCategoryId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="namePattern")
        private String namePattern;
        @JsonProperty(value="commentPattern")
        private String commentPattern;
        @JsonProperty(value="dataPattern")
        private String dataPattern;
        @JsonProperty(value="searchType")
        private SensitiveTypePattern.SearchType searchType;
        @JsonProperty(value="defaultMaskingFormatId")
        private String defaultMaskingFormatId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder shortName(String shortName) {
            this.shortName = shortName;
            this.__explicitlySet__.add("shortName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder parentCategoryId(String parentCategoryId) {
            this.parentCategoryId = parentCategoryId;
            this.__explicitlySet__.add("parentCategoryId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            this.__explicitlySet__.add("namePattern");
            return this;
        }

        public Builder commentPattern(String commentPattern) {
            this.commentPattern = commentPattern;
            this.__explicitlySet__.add("commentPattern");
            return this;
        }

        public Builder dataPattern(String dataPattern) {
            this.dataPattern = dataPattern;
            this.__explicitlySet__.add("dataPattern");
            return this;
        }

        public Builder searchType(SensitiveTypePattern.SearchType searchType) {
            this.searchType = searchType;
            this.__explicitlySet__.add("searchType");
            return this;
        }

        public Builder defaultMaskingFormatId(String defaultMaskingFormatId) {
            this.defaultMaskingFormatId = defaultMaskingFormatId;
            this.__explicitlySet__.add("defaultMaskingFormatId");
            return this;
        }

        public UpdateSensitiveTypePatternDetails build() {
            UpdateSensitiveTypePatternDetails model = new UpdateSensitiveTypePatternDetails(this.displayName, this.shortName, this.description, this.parentCategoryId, this.freeformTags, this.definedTags, this.namePattern, this.commentPattern, this.dataPattern, this.searchType, this.defaultMaskingFormatId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateSensitiveTypePatternDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("shortName")) {
                this.shortName(model.getShortName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("parentCategoryId")) {
                this.parentCategoryId(model.getParentCategoryId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("namePattern")) {
                this.namePattern(model.getNamePattern());
            }
            if (model.wasPropertyExplicitlySet("commentPattern")) {
                this.commentPattern(model.getCommentPattern());
            }
            if (model.wasPropertyExplicitlySet("dataPattern")) {
                this.dataPattern(model.getDataPattern());
            }
            if (model.wasPropertyExplicitlySet("searchType")) {
                this.searchType(model.getSearchType());
            }
            if (model.wasPropertyExplicitlySet("defaultMaskingFormatId")) {
                this.defaultMaskingFormatId(model.getDefaultMaskingFormatId());
            }
            return this;
        }
    }
}

