/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.SensitiveColumnLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SensitiveColumn
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="sensitiveDataModelId")
    private final String sensitiveDataModelId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final SensitiveColumnLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="appName")
    private final String appName;
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;
    @JsonProperty(value="source")
    private final Source source;
    @JsonProperty(value="parentColumnKeys")
    private final List<String> parentColumnKeys;
    @JsonProperty(value="relationType")
    private final RelationType relationType;
    @JsonProperty(value="estimatedDataValueCount")
    private final Long estimatedDataValueCount;
    @JsonProperty(value="sampleDataValues")
    private final List<String> sampleDataValues;
    @JsonProperty(value="appDefinedChildColumnKeys")
    private final List<String> appDefinedChildColumnKeys;
    @JsonProperty(value="dbDefinedChildColumnKeys")
    private final List<String> dbDefinedChildColumnKeys;
    @JsonProperty(value="columnGroups")
    private final List<String> columnGroups;

    @Deprecated
    @ConstructorProperties(value={"key", "sensitiveDataModelId", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "appName", "schemaName", "objectName", "columnName", "objectType", "dataType", "status", "sensitiveTypeId", "source", "parentColumnKeys", "relationType", "estimatedDataValueCount", "sampleDataValues", "appDefinedChildColumnKeys", "dbDefinedChildColumnKeys", "columnGroups"})
    public SensitiveColumn(String key, String sensitiveDataModelId, Date timeCreated, Date timeUpdated, SensitiveColumnLifecycleState lifecycleState, String lifecycleDetails, String appName, String schemaName, String objectName, String columnName, ObjectType objectType, String dataType, Status status, String sensitiveTypeId, Source source, List<String> parentColumnKeys, RelationType relationType, Long estimatedDataValueCount, List<String> sampleDataValues, List<String> appDefinedChildColumnKeys, List<String> dbDefinedChildColumnKeys, List<String> columnGroups) {
        this.key = key;
        this.sensitiveDataModelId = sensitiveDataModelId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.appName = appName;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.columnName = columnName;
        this.objectType = objectType;
        this.dataType = dataType;
        this.status = status;
        this.sensitiveTypeId = sensitiveTypeId;
        this.source = source;
        this.parentColumnKeys = parentColumnKeys;
        this.relationType = relationType;
        this.estimatedDataValueCount = estimatedDataValueCount;
        this.sampleDataValues = sampleDataValues;
        this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
        this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
        this.columnGroups = columnGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public SensitiveColumnLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public Source getSource() {
        return this.source;
    }

    public List<String> getParentColumnKeys() {
        return this.parentColumnKeys;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public Long getEstimatedDataValueCount() {
        return this.estimatedDataValueCount;
    }

    public List<String> getSampleDataValues() {
        return this.sampleDataValues;
    }

    public List<String> getAppDefinedChildColumnKeys() {
        return this.appDefinedChildColumnKeys;
    }

    public List<String> getDbDefinedChildColumnKeys() {
        return this.dbDefinedChildColumnKeys;
    }

    public List<String> getColumnGroups() {
        return this.columnGroups;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SensitiveColumn(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", appName=").append(String.valueOf(this.appName));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", parentColumnKeys=").append(String.valueOf(this.parentColumnKeys));
        sb.append(", relationType=").append(String.valueOf((Object)this.relationType));
        sb.append(", estimatedDataValueCount=").append(String.valueOf(this.estimatedDataValueCount));
        sb.append(", sampleDataValues=").append(String.valueOf(this.sampleDataValues));
        sb.append(", appDefinedChildColumnKeys=").append(String.valueOf(this.appDefinedChildColumnKeys));
        sb.append(", dbDefinedChildColumnKeys=").append(String.valueOf(this.dbDefinedChildColumnKeys));
        sb.append(", columnGroups=").append(String.valueOf(this.columnGroups));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SensitiveColumn)) {
            return false;
        }
        SensitiveColumn other = (SensitiveColumn)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.appName, other.appName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.dataType, other.dataType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.parentColumnKeys, other.parentColumnKeys) && Objects.equals((Object)this.relationType, (Object)other.relationType) && Objects.equals(this.estimatedDataValueCount, other.estimatedDataValueCount) && Objects.equals(this.sampleDataValues, other.sampleDataValues) && Objects.equals(this.appDefinedChildColumnKeys, other.appDefinedChildColumnKeys) && Objects.equals(this.dbDefinedChildColumnKeys, other.dbDefinedChildColumnKeys) && Objects.equals(this.columnGroups, other.columnGroups) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.appName == null ? 43 : this.appName.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.parentColumnKeys == null ? 43 : this.parentColumnKeys.hashCode());
        result = result * 59 + (this.relationType == null ? 43 : this.relationType.hashCode());
        result = result * 59 + (this.estimatedDataValueCount == null ? 43 : this.estimatedDataValueCount.hashCode());
        result = result * 59 + (this.sampleDataValues == null ? 43 : this.sampleDataValues.hashCode());
        result = result * 59 + (this.appDefinedChildColumnKeys == null ? 43 : this.appDefinedChildColumnKeys.hashCode());
        result = result * 59 + (this.dbDefinedChildColumnKeys == null ? 43 : this.dbDefinedChildColumnKeys.hashCode());
        result = result * 59 + (this.columnGroups == null ? 43 : this.columnGroups.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RelationType implements BmcEnum
    {
        None("NONE"),
        AppDefined("APP_DEFINED"),
        DbDefined("DB_DEFINED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RelationType> map;

        private RelationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RelationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RelationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RelationType.class);
            map = new HashMap<String, RelationType>();
            for (RelationType v : RelationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Source implements BmcEnum
    {
        Manual("MANUAL"),
        Discovery("DISCOVERY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Source', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Source.class);
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Valid("VALID"),
        Invalid("INVALID"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ObjectType implements BmcEnum
    {
        Table("TABLE"),
        EditioningView("EDITIONING_VIEW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ObjectType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ObjectType.class);
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="sensitiveDataModelId")
        private String sensitiveDataModelId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private SensitiveColumnLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="appName")
        private String appName;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonProperty(value="source")
        private Source source;
        @JsonProperty(value="parentColumnKeys")
        private List<String> parentColumnKeys;
        @JsonProperty(value="relationType")
        private RelationType relationType;
        @JsonProperty(value="estimatedDataValueCount")
        private Long estimatedDataValueCount;
        @JsonProperty(value="sampleDataValues")
        private List<String> sampleDataValues;
        @JsonProperty(value="appDefinedChildColumnKeys")
        private List<String> appDefinedChildColumnKeys;
        @JsonProperty(value="dbDefinedChildColumnKeys")
        private List<String> dbDefinedChildColumnKeys;
        @JsonProperty(value="columnGroups")
        private List<String> columnGroups;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            this.__explicitlySet__.add("sensitiveDataModelId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(SensitiveColumnLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            this.__explicitlySet__.add("appName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder parentColumnKeys(List<String> parentColumnKeys) {
            this.parentColumnKeys = parentColumnKeys;
            this.__explicitlySet__.add("parentColumnKeys");
            return this;
        }

        public Builder relationType(RelationType relationType) {
            this.relationType = relationType;
            this.__explicitlySet__.add("relationType");
            return this;
        }

        public Builder estimatedDataValueCount(Long estimatedDataValueCount) {
            this.estimatedDataValueCount = estimatedDataValueCount;
            this.__explicitlySet__.add("estimatedDataValueCount");
            return this;
        }

        public Builder sampleDataValues(List<String> sampleDataValues) {
            this.sampleDataValues = sampleDataValues;
            this.__explicitlySet__.add("sampleDataValues");
            return this;
        }

        public Builder appDefinedChildColumnKeys(List<String> appDefinedChildColumnKeys) {
            this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
            this.__explicitlySet__.add("appDefinedChildColumnKeys");
            return this;
        }

        public Builder dbDefinedChildColumnKeys(List<String> dbDefinedChildColumnKeys) {
            this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
            this.__explicitlySet__.add("dbDefinedChildColumnKeys");
            return this;
        }

        public Builder columnGroups(List<String> columnGroups) {
            this.columnGroups = columnGroups;
            this.__explicitlySet__.add("columnGroups");
            return this;
        }

        public SensitiveColumn build() {
            SensitiveColumn model = new SensitiveColumn(this.key, this.sensitiveDataModelId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.appName, this.schemaName, this.objectName, this.columnName, this.objectType, this.dataType, this.status, this.sensitiveTypeId, this.source, this.parentColumnKeys, this.relationType, this.estimatedDataValueCount, this.sampleDataValues, this.appDefinedChildColumnKeys, this.dbDefinedChildColumnKeys, this.columnGroups);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SensitiveColumn model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("sensitiveDataModelId")) {
                this.sensitiveDataModelId(model.getSensitiveDataModelId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("appName")) {
                this.appName(model.getAppName());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("parentColumnKeys")) {
                this.parentColumnKeys(model.getParentColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("relationType")) {
                this.relationType(model.getRelationType());
            }
            if (model.wasPropertyExplicitlySet("estimatedDataValueCount")) {
                this.estimatedDataValueCount(model.getEstimatedDataValueCount());
            }
            if (model.wasPropertyExplicitlySet("sampleDataValues")) {
                this.sampleDataValues(model.getSampleDataValues());
            }
            if (model.wasPropertyExplicitlySet("appDefinedChildColumnKeys")) {
                this.appDefinedChildColumnKeys(model.getAppDefinedChildColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("dbDefinedChildColumnKeys")) {
                this.dbDefinedChildColumnKeys(model.getDbDefinedChildColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("columnGroups")) {
                this.columnGroups(model.getColumnGroups());
            }
            return this;
        }
    }
}

