/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ReportDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduleReportDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="schedule")
    private final String schedule;
    @JsonProperty(value="mimeType")
    private final MimeType mimeType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="reportDetails")
    private final ReportDetails reportDetails;

    @Deprecated
    @ConstructorProperties(value={"displayName", "schedule", "mimeType", "compartmentId", "reportDetails"})
    public ScheduleReportDetails(String displayName, String schedule, MimeType mimeType, String compartmentId, ReportDetails reportDetails) {
        this.displayName = displayName;
        this.schedule = schedule;
        this.mimeType = mimeType;
        this.compartmentId = compartmentId;
        this.reportDetails = reportDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ReportDetails getReportDetails() {
        return this.reportDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduleReportDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", schedule=").append(String.valueOf(this.schedule));
        sb.append(", mimeType=").append(String.valueOf((Object)this.mimeType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", reportDetails=").append(String.valueOf((Object)this.reportDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleReportDetails)) {
            return false;
        }
        ScheduleReportDetails other = (ScheduleReportDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.schedule, other.schedule) && Objects.equals((Object)this.mimeType, (Object)other.mimeType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.reportDetails, (Object)other.reportDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.schedule == null ? 43 : this.schedule.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.reportDetails == null ? 43 : this.reportDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MimeType implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS");

        private final String value;
        private static Map<String, MimeType> map;

        private MimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MimeType: " + key);
        }

        static {
            map = new HashMap<String, MimeType>();
            for (MimeType v : MimeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="schedule")
        private String schedule;
        @JsonProperty(value="mimeType")
        private MimeType mimeType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="reportDetails")
        private ReportDetails reportDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }

        public Builder mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            this.__explicitlySet__.add("mimeType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder reportDetails(ReportDetails reportDetails) {
            this.reportDetails = reportDetails;
            this.__explicitlySet__.add("reportDetails");
            return this;
        }

        public ScheduleReportDetails build() {
            ScheduleReportDetails model = new ScheduleReportDetails(this.displayName, this.schedule, this.mimeType, this.compartmentId, this.reportDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduleReportDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            if (model.wasPropertyExplicitlySet("mimeType")) {
                this.mimeType(model.getMimeType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("reportDetails")) {
                this.reportDetails(model.getReportDetails());
            }
            return this;
        }
    }
}

