/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="roleName")
    private final String roleName;
    @JsonProperty(value="authenticationType")
    private final String authenticationType;
    @JsonProperty(value="isPasswordRequired")
    private final Boolean isPasswordRequired;
    @JsonProperty(value="isCommon")
    private final Boolean isCommon;
    @JsonProperty(value="isOracleMaintained")
    private final Boolean isOracleMaintained;
    @JsonProperty(value="isInherited")
    private final Boolean isInherited;
    @JsonProperty(value="isImplicit")
    private final Boolean isImplicit;

    @Deprecated
    @ConstructorProperties(value={"roleName", "authenticationType", "isPasswordRequired", "isCommon", "isOracleMaintained", "isInherited", "isImplicit"})
    public RoleSummary(String roleName, String authenticationType, Boolean isPasswordRequired, Boolean isCommon, Boolean isOracleMaintained, Boolean isInherited, Boolean isImplicit) {
        this.roleName = roleName;
        this.authenticationType = authenticationType;
        this.isPasswordRequired = isPasswordRequired;
        this.isCommon = isCommon;
        this.isOracleMaintained = isOracleMaintained;
        this.isInherited = isInherited;
        this.isImplicit = isImplicit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public Boolean getIsPasswordRequired() {
        return this.isPasswordRequired;
    }

    public Boolean getIsCommon() {
        return this.isCommon;
    }

    public Boolean getIsOracleMaintained() {
        return this.isOracleMaintained;
    }

    public Boolean getIsInherited() {
        return this.isInherited;
    }

    public Boolean getIsImplicit() {
        return this.isImplicit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("roleName=").append(String.valueOf(this.roleName));
        sb.append(", authenticationType=").append(String.valueOf(this.authenticationType));
        sb.append(", isPasswordRequired=").append(String.valueOf(this.isPasswordRequired));
        sb.append(", isCommon=").append(String.valueOf(this.isCommon));
        sb.append(", isOracleMaintained=").append(String.valueOf(this.isOracleMaintained));
        sb.append(", isInherited=").append(String.valueOf(this.isInherited));
        sb.append(", isImplicit=").append(String.valueOf(this.isImplicit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleSummary)) {
            return false;
        }
        RoleSummary other = (RoleSummary)((Object)o);
        return Objects.equals(this.roleName, other.roleName) && Objects.equals(this.authenticationType, other.authenticationType) && Objects.equals(this.isPasswordRequired, other.isPasswordRequired) && Objects.equals(this.isCommon, other.isCommon) && Objects.equals(this.isOracleMaintained, other.isOracleMaintained) && Objects.equals(this.isInherited, other.isInherited) && Objects.equals(this.isImplicit, other.isImplicit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.roleName == null ? 43 : this.roleName.hashCode());
        result = result * 59 + (this.authenticationType == null ? 43 : this.authenticationType.hashCode());
        result = result * 59 + (this.isPasswordRequired == null ? 43 : this.isPasswordRequired.hashCode());
        result = result * 59 + (this.isCommon == null ? 43 : this.isCommon.hashCode());
        result = result * 59 + (this.isOracleMaintained == null ? 43 : this.isOracleMaintained.hashCode());
        result = result * 59 + (this.isInherited == null ? 43 : this.isInherited.hashCode());
        result = result * 59 + (this.isImplicit == null ? 43 : this.isImplicit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="roleName")
        private String roleName;
        @JsonProperty(value="authenticationType")
        private String authenticationType;
        @JsonProperty(value="isPasswordRequired")
        private Boolean isPasswordRequired;
        @JsonProperty(value="isCommon")
        private Boolean isCommon;
        @JsonProperty(value="isOracleMaintained")
        private Boolean isOracleMaintained;
        @JsonProperty(value="isInherited")
        private Boolean isInherited;
        @JsonProperty(value="isImplicit")
        private Boolean isImplicit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder roleName(String roleName) {
            this.roleName = roleName;
            this.__explicitlySet__.add("roleName");
            return this;
        }

        public Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            this.__explicitlySet__.add("authenticationType");
            return this;
        }

        public Builder isPasswordRequired(Boolean isPasswordRequired) {
            this.isPasswordRequired = isPasswordRequired;
            this.__explicitlySet__.add("isPasswordRequired");
            return this;
        }

        public Builder isCommon(Boolean isCommon) {
            this.isCommon = isCommon;
            this.__explicitlySet__.add("isCommon");
            return this;
        }

        public Builder isOracleMaintained(Boolean isOracleMaintained) {
            this.isOracleMaintained = isOracleMaintained;
            this.__explicitlySet__.add("isOracleMaintained");
            return this;
        }

        public Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            this.__explicitlySet__.add("isInherited");
            return this;
        }

        public Builder isImplicit(Boolean isImplicit) {
            this.isImplicit = isImplicit;
            this.__explicitlySet__.add("isImplicit");
            return this;
        }

        public RoleSummary build() {
            RoleSummary model = new RoleSummary(this.roleName, this.authenticationType, this.isPasswordRequired, this.isCommon, this.isOracleMaintained, this.isInherited, this.isImplicit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoleSummary model) {
            if (model.wasPropertyExplicitlySet("roleName")) {
                this.roleName(model.getRoleName());
            }
            if (model.wasPropertyExplicitlySet("authenticationType")) {
                this.authenticationType(model.getAuthenticationType());
            }
            if (model.wasPropertyExplicitlySet("isPasswordRequired")) {
                this.isPasswordRequired(model.getIsPasswordRequired());
            }
            if (model.wasPropertyExplicitlySet("isCommon")) {
                this.isCommon(model.getIsCommon());
            }
            if (model.wasPropertyExplicitlySet("isOracleMaintained")) {
                this.isOracleMaintained(model.getIsOracleMaintained());
            }
            if (model.wasPropertyExplicitlySet("isInherited")) {
                this.isInherited(model.getIsInherited());
            }
            if (model.wasPropertyExplicitlySet("isImplicit")) {
                this.isImplicit(model.getIsImplicit());
            }
            return this;
        }
    }
}

