/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RandomStringFormatEntry
extends FormatEntry {
    @JsonProperty(value="startLength")
    private final Integer startLength;
    @JsonProperty(value="endLength")
    private final Integer endLength;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RandomStringFormatEntry(String description, Integer startLength, Integer endLength) {
        super(description);
        this.startLength = startLength;
        this.endLength = endLength;
    }

    public Integer getStartLength() {
        return this.startLength;
    }

    public Integer getEndLength() {
        return this.endLength;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RandomStringFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", startLength=").append(String.valueOf(this.startLength));
        sb.append(", endLength=").append(String.valueOf(this.endLength));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RandomStringFormatEntry)) {
            return false;
        }
        RandomStringFormatEntry other = (RandomStringFormatEntry)((Object)o);
        return Objects.equals(this.startLength, other.startLength) && Objects.equals(this.endLength, other.endLength) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.startLength == null ? 43 : this.startLength.hashCode());
        result = result * 59 + (this.endLength == null ? 43 : this.endLength.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="startLength")
        private Integer startLength;
        @JsonProperty(value="endLength")
        private Integer endLength;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder startLength(Integer startLength) {
            this.startLength = startLength;
            this.__explicitlySet__.add("startLength");
            return this;
        }

        public Builder endLength(Integer endLength) {
            this.endLength = endLength;
            this.__explicitlySet__.add("endLength");
            return this;
        }

        public RandomStringFormatEntry build() {
            RandomStringFormatEntry model = new RandomStringFormatEntry(this.description, this.startLength, this.endLength);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RandomStringFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("startLength")) {
                this.startLength(model.getStartLength());
            }
            if (model.wasPropertyExplicitlySet("endLength")) {
                this.endLength(model.getEndLength());
            }
            return this;
        }
    }
}

