/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.MaskingLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskingReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="maskingWorkRequestId")
    private final String maskingWorkRequestId;
    @JsonProperty(value="maskingPolicyId")
    private final String maskingPolicyId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="totalMaskedSensitiveTypes")
    private final Long totalMaskedSensitiveTypes;
    @JsonProperty(value="totalMaskedSchemas")
    private final Long totalMaskedSchemas;
    @JsonProperty(value="totalMaskedObjects")
    private final Long totalMaskedObjects;
    @JsonProperty(value="totalMaskedColumns")
    private final Long totalMaskedColumns;
    @JsonProperty(value="totalMaskedValues")
    private final Long totalMaskedValues;
    @JsonProperty(value="timeMaskingStarted")
    private final Date timeMaskingStarted;
    @JsonProperty(value="timeMaskingFinished")
    private final Date timeMaskingFinished;
    @JsonProperty(value="lifecycleState")
    private final MaskingLifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "maskingWorkRequestId", "maskingPolicyId", "targetId", "totalMaskedSensitiveTypes", "totalMaskedSchemas", "totalMaskedObjects", "totalMaskedColumns", "totalMaskedValues", "timeMaskingStarted", "timeMaskingFinished", "lifecycleState", "timeCreated"})
    public MaskingReport(String id, String compartmentId, String maskingWorkRequestId, String maskingPolicyId, String targetId, Long totalMaskedSensitiveTypes, Long totalMaskedSchemas, Long totalMaskedObjects, Long totalMaskedColumns, Long totalMaskedValues, Date timeMaskingStarted, Date timeMaskingFinished, MaskingLifecycleState lifecycleState, Date timeCreated) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.maskingWorkRequestId = maskingWorkRequestId;
        this.maskingPolicyId = maskingPolicyId;
        this.targetId = targetId;
        this.totalMaskedSensitiveTypes = totalMaskedSensitiveTypes;
        this.totalMaskedSchemas = totalMaskedSchemas;
        this.totalMaskedObjects = totalMaskedObjects;
        this.totalMaskedColumns = totalMaskedColumns;
        this.totalMaskedValues = totalMaskedValues;
        this.timeMaskingStarted = timeMaskingStarted;
        this.timeMaskingFinished = timeMaskingFinished;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getMaskingWorkRequestId() {
        return this.maskingWorkRequestId;
    }

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Long getTotalMaskedSensitiveTypes() {
        return this.totalMaskedSensitiveTypes;
    }

    public Long getTotalMaskedSchemas() {
        return this.totalMaskedSchemas;
    }

    public Long getTotalMaskedObjects() {
        return this.totalMaskedObjects;
    }

    public Long getTotalMaskedColumns() {
        return this.totalMaskedColumns;
    }

    public Long getTotalMaskedValues() {
        return this.totalMaskedValues;
    }

    public Date getTimeMaskingStarted() {
        return this.timeMaskingStarted;
    }

    public Date getTimeMaskingFinished() {
        return this.timeMaskingFinished;
    }

    public MaskingLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskingReport(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", maskingWorkRequestId=").append(String.valueOf(this.maskingWorkRequestId));
        sb.append(", maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", totalMaskedSensitiveTypes=").append(String.valueOf(this.totalMaskedSensitiveTypes));
        sb.append(", totalMaskedSchemas=").append(String.valueOf(this.totalMaskedSchemas));
        sb.append(", totalMaskedObjects=").append(String.valueOf(this.totalMaskedObjects));
        sb.append(", totalMaskedColumns=").append(String.valueOf(this.totalMaskedColumns));
        sb.append(", totalMaskedValues=").append(String.valueOf(this.totalMaskedValues));
        sb.append(", timeMaskingStarted=").append(String.valueOf(this.timeMaskingStarted));
        sb.append(", timeMaskingFinished=").append(String.valueOf(this.timeMaskingFinished));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskingReport)) {
            return false;
        }
        MaskingReport other = (MaskingReport)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.maskingWorkRequestId, other.maskingWorkRequestId) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.totalMaskedSensitiveTypes, other.totalMaskedSensitiveTypes) && Objects.equals(this.totalMaskedSchemas, other.totalMaskedSchemas) && Objects.equals(this.totalMaskedObjects, other.totalMaskedObjects) && Objects.equals(this.totalMaskedColumns, other.totalMaskedColumns) && Objects.equals(this.totalMaskedValues, other.totalMaskedValues) && Objects.equals(this.timeMaskingStarted, other.timeMaskingStarted) && Objects.equals(this.timeMaskingFinished, other.timeMaskingFinished) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.maskingWorkRequestId == null ? 43 : this.maskingWorkRequestId.hashCode());
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.totalMaskedSensitiveTypes == null ? 43 : this.totalMaskedSensitiveTypes.hashCode());
        result = result * 59 + (this.totalMaskedSchemas == null ? 43 : this.totalMaskedSchemas.hashCode());
        result = result * 59 + (this.totalMaskedObjects == null ? 43 : this.totalMaskedObjects.hashCode());
        result = result * 59 + (this.totalMaskedColumns == null ? 43 : this.totalMaskedColumns.hashCode());
        result = result * 59 + (this.totalMaskedValues == null ? 43 : this.totalMaskedValues.hashCode());
        result = result * 59 + (this.timeMaskingStarted == null ? 43 : this.timeMaskingStarted.hashCode());
        result = result * 59 + (this.timeMaskingFinished == null ? 43 : this.timeMaskingFinished.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="maskingWorkRequestId")
        private String maskingWorkRequestId;
        @JsonProperty(value="maskingPolicyId")
        private String maskingPolicyId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="totalMaskedSensitiveTypes")
        private Long totalMaskedSensitiveTypes;
        @JsonProperty(value="totalMaskedSchemas")
        private Long totalMaskedSchemas;
        @JsonProperty(value="totalMaskedObjects")
        private Long totalMaskedObjects;
        @JsonProperty(value="totalMaskedColumns")
        private Long totalMaskedColumns;
        @JsonProperty(value="totalMaskedValues")
        private Long totalMaskedValues;
        @JsonProperty(value="timeMaskingStarted")
        private Date timeMaskingStarted;
        @JsonProperty(value="timeMaskingFinished")
        private Date timeMaskingFinished;
        @JsonProperty(value="lifecycleState")
        private MaskingLifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder maskingWorkRequestId(String maskingWorkRequestId) {
            this.maskingWorkRequestId = maskingWorkRequestId;
            this.__explicitlySet__.add("maskingWorkRequestId");
            return this;
        }

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            this.__explicitlySet__.add("maskingPolicyId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder totalMaskedSensitiveTypes(Long totalMaskedSensitiveTypes) {
            this.totalMaskedSensitiveTypes = totalMaskedSensitiveTypes;
            this.__explicitlySet__.add("totalMaskedSensitiveTypes");
            return this;
        }

        public Builder totalMaskedSchemas(Long totalMaskedSchemas) {
            this.totalMaskedSchemas = totalMaskedSchemas;
            this.__explicitlySet__.add("totalMaskedSchemas");
            return this;
        }

        public Builder totalMaskedObjects(Long totalMaskedObjects) {
            this.totalMaskedObjects = totalMaskedObjects;
            this.__explicitlySet__.add("totalMaskedObjects");
            return this;
        }

        public Builder totalMaskedColumns(Long totalMaskedColumns) {
            this.totalMaskedColumns = totalMaskedColumns;
            this.__explicitlySet__.add("totalMaskedColumns");
            return this;
        }

        public Builder totalMaskedValues(Long totalMaskedValues) {
            this.totalMaskedValues = totalMaskedValues;
            this.__explicitlySet__.add("totalMaskedValues");
            return this;
        }

        public Builder timeMaskingStarted(Date timeMaskingStarted) {
            this.timeMaskingStarted = timeMaskingStarted;
            this.__explicitlySet__.add("timeMaskingStarted");
            return this;
        }

        public Builder timeMaskingFinished(Date timeMaskingFinished) {
            this.timeMaskingFinished = timeMaskingFinished;
            this.__explicitlySet__.add("timeMaskingFinished");
            return this;
        }

        public Builder lifecycleState(MaskingLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public MaskingReport build() {
            MaskingReport model = new MaskingReport(this.id, this.compartmentId, this.maskingWorkRequestId, this.maskingPolicyId, this.targetId, this.totalMaskedSensitiveTypes, this.totalMaskedSchemas, this.totalMaskedObjects, this.totalMaskedColumns, this.totalMaskedValues, this.timeMaskingStarted, this.timeMaskingFinished, this.lifecycleState, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskingReport model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("maskingWorkRequestId")) {
                this.maskingWorkRequestId(model.getMaskingWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("maskingPolicyId")) {
                this.maskingPolicyId(model.getMaskingPolicyId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedSensitiveTypes")) {
                this.totalMaskedSensitiveTypes(model.getTotalMaskedSensitiveTypes());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedSchemas")) {
                this.totalMaskedSchemas(model.getTotalMaskedSchemas());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedObjects")) {
                this.totalMaskedObjects(model.getTotalMaskedObjects());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedColumns")) {
                this.totalMaskedColumns(model.getTotalMaskedColumns());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedValues")) {
                this.totalMaskedValues(model.getTotalMaskedValues());
            }
            if (model.wasPropertyExplicitlySet("timeMaskingStarted")) {
                this.timeMaskingStarted(model.getTimeMaskingStarted());
            }
            if (model.wasPropertyExplicitlySet("timeMaskingFinished")) {
                this.timeMaskingFinished(model.getTimeMaskingFinished());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

