/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskDataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="isDecrypt")
    private final Boolean isDecrypt;
    @JsonProperty(value="isRerun")
    private final Boolean isRerun;
    @JsonProperty(value="tablespace")
    private final String tablespace;
    @JsonProperty(value="isIgnoreErrorsEnabled")
    private final Boolean isIgnoreErrorsEnabled;
    @JsonProperty(value="seed")
    private final String seed;
    @JsonProperty(value="isMoveInterimTablesEnabled")
    private final Boolean isMoveInterimTablesEnabled;
    @JsonProperty(value="isExecuteSavedScriptEnabled")
    private final Boolean isExecuteSavedScriptEnabled;

    @Deprecated
    @ConstructorProperties(value={"targetId", "isDecrypt", "isRerun", "tablespace", "isIgnoreErrorsEnabled", "seed", "isMoveInterimTablesEnabled", "isExecuteSavedScriptEnabled"})
    public MaskDataDetails(String targetId, Boolean isDecrypt, Boolean isRerun, String tablespace, Boolean isIgnoreErrorsEnabled, String seed, Boolean isMoveInterimTablesEnabled, Boolean isExecuteSavedScriptEnabled) {
        this.targetId = targetId;
        this.isDecrypt = isDecrypt;
        this.isRerun = isRerun;
        this.tablespace = tablespace;
        this.isIgnoreErrorsEnabled = isIgnoreErrorsEnabled;
        this.seed = seed;
        this.isMoveInterimTablesEnabled = isMoveInterimTablesEnabled;
        this.isExecuteSavedScriptEnabled = isExecuteSavedScriptEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Boolean getIsDecrypt() {
        return this.isDecrypt;
    }

    public Boolean getIsRerun() {
        return this.isRerun;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public Boolean getIsIgnoreErrorsEnabled() {
        return this.isIgnoreErrorsEnabled;
    }

    public String getSeed() {
        return this.seed;
    }

    public Boolean getIsMoveInterimTablesEnabled() {
        return this.isMoveInterimTablesEnabled;
    }

    public Boolean getIsExecuteSavedScriptEnabled() {
        return this.isExecuteSavedScriptEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskDataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targetId=").append(String.valueOf(this.targetId));
        sb.append(", isDecrypt=").append(String.valueOf(this.isDecrypt));
        sb.append(", isRerun=").append(String.valueOf(this.isRerun));
        sb.append(", tablespace=").append(String.valueOf(this.tablespace));
        sb.append(", isIgnoreErrorsEnabled=").append(String.valueOf(this.isIgnoreErrorsEnabled));
        sb.append(", seed=").append("<redacted>");
        sb.append(", isMoveInterimTablesEnabled=").append(String.valueOf(this.isMoveInterimTablesEnabled));
        sb.append(", isExecuteSavedScriptEnabled=").append(String.valueOf(this.isExecuteSavedScriptEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskDataDetails)) {
            return false;
        }
        MaskDataDetails other = (MaskDataDetails)((Object)o);
        return Objects.equals(this.targetId, other.targetId) && Objects.equals(this.isDecrypt, other.isDecrypt) && Objects.equals(this.isRerun, other.isRerun) && Objects.equals(this.tablespace, other.tablespace) && Objects.equals(this.isIgnoreErrorsEnabled, other.isIgnoreErrorsEnabled) && Objects.equals(this.seed, other.seed) && Objects.equals(this.isMoveInterimTablesEnabled, other.isMoveInterimTablesEnabled) && Objects.equals(this.isExecuteSavedScriptEnabled, other.isExecuteSavedScriptEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.isDecrypt == null ? 43 : this.isDecrypt.hashCode());
        result = result * 59 + (this.isRerun == null ? 43 : this.isRerun.hashCode());
        result = result * 59 + (this.tablespace == null ? 43 : this.tablespace.hashCode());
        result = result * 59 + (this.isIgnoreErrorsEnabled == null ? 43 : this.isIgnoreErrorsEnabled.hashCode());
        result = result * 59 + (this.seed == null ? 43 : this.seed.hashCode());
        result = result * 59 + (this.isMoveInterimTablesEnabled == null ? 43 : this.isMoveInterimTablesEnabled.hashCode());
        result = result * 59 + (this.isExecuteSavedScriptEnabled == null ? 43 : this.isExecuteSavedScriptEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="isDecrypt")
        private Boolean isDecrypt;
        @JsonProperty(value="isRerun")
        private Boolean isRerun;
        @JsonProperty(value="tablespace")
        private String tablespace;
        @JsonProperty(value="isIgnoreErrorsEnabled")
        private Boolean isIgnoreErrorsEnabled;
        @JsonProperty(value="seed")
        private String seed;
        @JsonProperty(value="isMoveInterimTablesEnabled")
        private Boolean isMoveInterimTablesEnabled;
        @JsonProperty(value="isExecuteSavedScriptEnabled")
        private Boolean isExecuteSavedScriptEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder isDecrypt(Boolean isDecrypt) {
            this.isDecrypt = isDecrypt;
            this.__explicitlySet__.add("isDecrypt");
            return this;
        }

        public Builder isRerun(Boolean isRerun) {
            this.isRerun = isRerun;
            this.__explicitlySet__.add("isRerun");
            return this;
        }

        public Builder tablespace(String tablespace) {
            this.tablespace = tablespace;
            this.__explicitlySet__.add("tablespace");
            return this;
        }

        public Builder isIgnoreErrorsEnabled(Boolean isIgnoreErrorsEnabled) {
            this.isIgnoreErrorsEnabled = isIgnoreErrorsEnabled;
            this.__explicitlySet__.add("isIgnoreErrorsEnabled");
            return this;
        }

        public Builder seed(String seed) {
            this.seed = seed;
            this.__explicitlySet__.add("seed");
            return this;
        }

        public Builder isMoveInterimTablesEnabled(Boolean isMoveInterimTablesEnabled) {
            this.isMoveInterimTablesEnabled = isMoveInterimTablesEnabled;
            this.__explicitlySet__.add("isMoveInterimTablesEnabled");
            return this;
        }

        public Builder isExecuteSavedScriptEnabled(Boolean isExecuteSavedScriptEnabled) {
            this.isExecuteSavedScriptEnabled = isExecuteSavedScriptEnabled;
            this.__explicitlySet__.add("isExecuteSavedScriptEnabled");
            return this;
        }

        public MaskDataDetails build() {
            MaskDataDetails model = new MaskDataDetails(this.targetId, this.isDecrypt, this.isRerun, this.tablespace, this.isIgnoreErrorsEnabled, this.seed, this.isMoveInterimTablesEnabled, this.isExecuteSavedScriptEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskDataDetails model) {
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("isDecrypt")) {
                this.isDecrypt(model.getIsDecrypt());
            }
            if (model.wasPropertyExplicitlySet("isRerun")) {
                this.isRerun(model.getIsRerun());
            }
            if (model.wasPropertyExplicitlySet("tablespace")) {
                this.tablespace(model.getTablespace());
            }
            if (model.wasPropertyExplicitlySet("isIgnoreErrorsEnabled")) {
                this.isIgnoreErrorsEnabled(model.getIsIgnoreErrorsEnabled());
            }
            if (model.wasPropertyExplicitlySet("seed")) {
                this.seed(model.getSeed());
            }
            if (model.wasPropertyExplicitlySet("isMoveInterimTablesEnabled")) {
                this.isMoveInterimTablesEnabled(model.getIsMoveInterimTablesEnabled());
            }
            if (model.wasPropertyExplicitlySet("isExecuteSavedScriptEnabled")) {
                this.isExecuteSavedScriptEnabled(model.getIsExecuteSavedScriptEnabled());
            }
            return this;
        }
    }
}

