/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GrantSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="grantName")
    private final String grantName;
    @JsonProperty(value="privilegeType")
    private final PrivilegeType privilegeType;
    @JsonProperty(value="privilegeCategory")
    private final PrivilegeCategory privilegeCategory;
    @JsonProperty(value="depthLevel")
    private final Integer depthLevel;

    @Deprecated
    @ConstructorProperties(value={"key", "grantName", "privilegeType", "privilegeCategory", "depthLevel"})
    public GrantSummary(String key, String grantName, PrivilegeType privilegeType, PrivilegeCategory privilegeCategory, Integer depthLevel) {
        this.key = key;
        this.grantName = grantName;
        this.privilegeType = privilegeType;
        this.privilegeCategory = privilegeCategory;
        this.depthLevel = depthLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getGrantName() {
        return this.grantName;
    }

    public PrivilegeType getPrivilegeType() {
        return this.privilegeType;
    }

    public PrivilegeCategory getPrivilegeCategory() {
        return this.privilegeCategory;
    }

    public Integer getDepthLevel() {
        return this.depthLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GrantSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", grantName=").append(String.valueOf(this.grantName));
        sb.append(", privilegeType=").append(String.valueOf((Object)this.privilegeType));
        sb.append(", privilegeCategory=").append(String.valueOf((Object)this.privilegeCategory));
        sb.append(", depthLevel=").append(String.valueOf(this.depthLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrantSummary)) {
            return false;
        }
        GrantSummary other = (GrantSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.grantName, other.grantName) && Objects.equals((Object)this.privilegeType, (Object)other.privilegeType) && Objects.equals((Object)this.privilegeCategory, (Object)other.privilegeCategory) && Objects.equals(this.depthLevel, other.depthLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.grantName == null ? 43 : this.grantName.hashCode());
        result = result * 59 + (this.privilegeType == null ? 43 : this.privilegeType.hashCode());
        result = result * 59 + (this.privilegeCategory == null ? 43 : this.privilegeCategory.hashCode());
        result = result * 59 + (this.depthLevel == null ? 43 : this.depthLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PrivilegeCategory implements BmcEnum
    {
        Critical("CRITICAL"),
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrivilegeCategory> map;

        private PrivilegeCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrivilegeCategory create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrivilegeCategory', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrivilegeCategory.class);
            map = new HashMap<String, PrivilegeCategory>();
            for (PrivilegeCategory v : PrivilegeCategory.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PrivilegeType implements BmcEnum
    {
        SystemPrivilege("SYSTEM_PRIVILEGE"),
        ObjectPrivilege("OBJECT_PRIVILEGE"),
        AdminPrivilege("ADMIN_PRIVILEGE"),
        Role("ROLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrivilegeType> map;

        private PrivilegeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrivilegeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrivilegeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrivilegeType.class);
            map = new HashMap<String, PrivilegeType>();
            for (PrivilegeType v : PrivilegeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="grantName")
        private String grantName;
        @JsonProperty(value="privilegeType")
        private PrivilegeType privilegeType;
        @JsonProperty(value="privilegeCategory")
        private PrivilegeCategory privilegeCategory;
        @JsonProperty(value="depthLevel")
        private Integer depthLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder grantName(String grantName) {
            this.grantName = grantName;
            this.__explicitlySet__.add("grantName");
            return this;
        }

        public Builder privilegeType(PrivilegeType privilegeType) {
            this.privilegeType = privilegeType;
            this.__explicitlySet__.add("privilegeType");
            return this;
        }

        public Builder privilegeCategory(PrivilegeCategory privilegeCategory) {
            this.privilegeCategory = privilegeCategory;
            this.__explicitlySet__.add("privilegeCategory");
            return this;
        }

        public Builder depthLevel(Integer depthLevel) {
            this.depthLevel = depthLevel;
            this.__explicitlySet__.add("depthLevel");
            return this;
        }

        public GrantSummary build() {
            GrantSummary model = new GrantSummary(this.key, this.grantName, this.privilegeType, this.privilegeCategory, this.depthLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GrantSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("grantName")) {
                this.grantName(model.getGrantName());
            }
            if (model.wasPropertyExplicitlySet("privilegeType")) {
                this.privilegeType(model.getPrivilegeType());
            }
            if (model.wasPropertyExplicitlySet("privilegeCategory")) {
                this.privilegeCategory(model.getPrivilegeCategory());
            }
            if (model.wasPropertyExplicitlySet("depthLevel")) {
                this.depthLevel(model.getDepthLevel());
            }
            return this;
        }
    }
}

