/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GlobalSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isPaidUsage")
    private final Boolean isPaidUsage;
    @JsonProperty(value="onlineRetentionPeriod")
    private final Integer onlineRetentionPeriod;
    @JsonProperty(value="offlineRetentionPeriod")
    private final Integer offlineRetentionPeriod;

    @Deprecated
    @ConstructorProperties(value={"isPaidUsage", "onlineRetentionPeriod", "offlineRetentionPeriod"})
    public GlobalSettings(Boolean isPaidUsage, Integer onlineRetentionPeriod, Integer offlineRetentionPeriod) {
        this.isPaidUsage = isPaidUsage;
        this.onlineRetentionPeriod = onlineRetentionPeriod;
        this.offlineRetentionPeriod = offlineRetentionPeriod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsPaidUsage() {
        return this.isPaidUsage;
    }

    public Integer getOnlineRetentionPeriod() {
        return this.onlineRetentionPeriod;
    }

    public Integer getOfflineRetentionPeriod() {
        return this.offlineRetentionPeriod;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalSettings(");
        sb.append("super=").append(super.toString());
        sb.append("isPaidUsage=").append(String.valueOf(this.isPaidUsage));
        sb.append(", onlineRetentionPeriod=").append(String.valueOf(this.onlineRetentionPeriod));
        sb.append(", offlineRetentionPeriod=").append(String.valueOf(this.offlineRetentionPeriod));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)((Object)o);
        return Objects.equals(this.isPaidUsage, other.isPaidUsage) && Objects.equals(this.onlineRetentionPeriod, other.onlineRetentionPeriod) && Objects.equals(this.offlineRetentionPeriod, other.offlineRetentionPeriod) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPaidUsage == null ? 43 : this.isPaidUsage.hashCode());
        result = result * 59 + (this.onlineRetentionPeriod == null ? 43 : this.onlineRetentionPeriod.hashCode());
        result = result * 59 + (this.offlineRetentionPeriod == null ? 43 : this.offlineRetentionPeriod.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isPaidUsage")
        private Boolean isPaidUsage;
        @JsonProperty(value="onlineRetentionPeriod")
        private Integer onlineRetentionPeriod;
        @JsonProperty(value="offlineRetentionPeriod")
        private Integer offlineRetentionPeriod;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isPaidUsage(Boolean isPaidUsage) {
            this.isPaidUsage = isPaidUsage;
            this.__explicitlySet__.add("isPaidUsage");
            return this;
        }

        public Builder onlineRetentionPeriod(Integer onlineRetentionPeriod) {
            this.onlineRetentionPeriod = onlineRetentionPeriod;
            this.__explicitlySet__.add("onlineRetentionPeriod");
            return this;
        }

        public Builder offlineRetentionPeriod(Integer offlineRetentionPeriod) {
            this.offlineRetentionPeriod = offlineRetentionPeriod;
            this.__explicitlySet__.add("offlineRetentionPeriod");
            return this;
        }

        public GlobalSettings build() {
            GlobalSettings model = new GlobalSettings(this.isPaidUsage, this.onlineRetentionPeriod, this.offlineRetentionPeriod);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GlobalSettings model) {
            if (model.wasPropertyExplicitlySet("isPaidUsage")) {
                this.isPaidUsage(model.getIsPaidUsage());
            }
            if (model.wasPropertyExplicitlySet("onlineRetentionPeriod")) {
                this.onlineRetentionPeriod(model.getOnlineRetentionPeriod());
            }
            if (model.wasPropertyExplicitlySet("offlineRetentionPeriod")) {
                this.offlineRetentionPeriod(model.getOfflineRetentionPeriod());
            }
            return this;
        }
    }
}

