/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateDiscoveryReportForDownloadDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="discoveryJobId")
    private final String discoveryJobId;
    @JsonProperty(value="reportFormat")
    private final ReportFormat reportFormat;

    @Deprecated
    @ConstructorProperties(value={"discoveryJobId", "reportFormat"})
    public GenerateDiscoveryReportForDownloadDetails(String discoveryJobId, ReportFormat reportFormat) {
        this.discoveryJobId = discoveryJobId;
        this.reportFormat = reportFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDiscoveryJobId() {
        return this.discoveryJobId;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateDiscoveryReportForDownloadDetails(");
        sb.append("super=").append(super.toString());
        sb.append("discoveryJobId=").append(String.valueOf(this.discoveryJobId));
        sb.append(", reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateDiscoveryReportForDownloadDetails)) {
            return false;
        }
        GenerateDiscoveryReportForDownloadDetails other = (GenerateDiscoveryReportForDownloadDetails)((Object)o);
        return Objects.equals(this.discoveryJobId, other.discoveryJobId) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.discoveryJobId == null ? 43 : this.discoveryJobId.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReportFormat implements BmcEnum
    {
        Pdf("PDF"),
        Xls("XLS");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="discoveryJobId")
        private String discoveryJobId;
        @JsonProperty(value="reportFormat")
        private ReportFormat reportFormat;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder discoveryJobId(String discoveryJobId) {
            this.discoveryJobId = discoveryJobId;
            this.__explicitlySet__.add("discoveryJobId");
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            this.__explicitlySet__.add("reportFormat");
            return this;
        }

        public GenerateDiscoveryReportForDownloadDetails build() {
            GenerateDiscoveryReportForDownloadDetails model = new GenerateDiscoveryReportForDownloadDetails(this.discoveryJobId, this.reportFormat);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateDiscoveryReportForDownloadDetails model) {
            if (model.wasPropertyExplicitlySet("discoveryJobId")) {
                this.discoveryJobId(model.getDiscoveryJobId());
            }
            if (model.wasPropertyExplicitlySet("reportFormat")) {
                this.reportFormat(model.getReportFormat());
            }
            return this;
        }
    }
}

