/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EnableConditions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entitySelection")
    private final EntitySelection entitySelection;
    @JsonProperty(value="entityType")
    private final EntityType entityType;
    @JsonProperty(value="operationStatus")
    private final OperationStatus operationStatus;
    @JsonProperty(value="entityNames")
    private final List<String> entityNames;

    @Deprecated
    @ConstructorProperties(value={"entitySelection", "entityType", "operationStatus", "entityNames"})
    public EnableConditions(EntitySelection entitySelection, EntityType entityType, OperationStatus operationStatus, List<String> entityNames) {
        this.entitySelection = entitySelection;
        this.entityType = entityType;
        this.operationStatus = operationStatus;
        this.entityNames = entityNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public EntitySelection getEntitySelection() {
        return this.entitySelection;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public List<String> getEntityNames() {
        return this.entityNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EnableConditions(");
        sb.append("super=").append(super.toString());
        sb.append("entitySelection=").append(String.valueOf((Object)this.entitySelection));
        sb.append(", entityType=").append(String.valueOf((Object)this.entityType));
        sb.append(", operationStatus=").append(String.valueOf((Object)this.operationStatus));
        sb.append(", entityNames=").append(String.valueOf(this.entityNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnableConditions)) {
            return false;
        }
        EnableConditions other = (EnableConditions)((Object)o);
        return Objects.equals((Object)this.entitySelection, (Object)other.entitySelection) && Objects.equals((Object)this.entityType, (Object)other.entityType) && Objects.equals((Object)this.operationStatus, (Object)other.operationStatus) && Objects.equals(this.entityNames, other.entityNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entitySelection == null ? 43 : this.entitySelection.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.entityNames == null ? 43 : this.entityNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationStatus implements BmcEnum
    {
        Success("SUCCESS"),
        Failure("FAILURE"),
        Both("BOTH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationStatus> map;

        private OperationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationStatus.class);
            map = new HashMap<String, OperationStatus>();
            for (OperationStatus v : OperationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EntityType implements BmcEnum
    {
        User("USER"),
        Role("ROLE"),
        AllUsers("ALL_USERS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EntityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EntityType.class);
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EntitySelection implements BmcEnum
    {
        Include("INCLUDE"),
        Exclude("EXCLUDE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EntitySelection> map;

        private EntitySelection(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntitySelection create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EntitySelection', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EntitySelection.class);
            map = new HashMap<String, EntitySelection>();
            for (EntitySelection v : EntitySelection.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entitySelection")
        private EntitySelection entitySelection;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonProperty(value="operationStatus")
        private OperationStatus operationStatus;
        @JsonProperty(value="entityNames")
        private List<String> entityNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entitySelection(EntitySelection entitySelection) {
            this.entitySelection = entitySelection;
            this.__explicitlySet__.add("entitySelection");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder entityNames(List<String> entityNames) {
            this.entityNames = entityNames;
            this.__explicitlySet__.add("entityNames");
            return this;
        }

        public EnableConditions build() {
            EnableConditions model = new EnableConditions(this.entitySelection, this.entityType, this.operationStatus, this.entityNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EnableConditions model) {
            if (model.wasPropertyExplicitlySet("entitySelection")) {
                this.entitySelection(model.getEntitySelection());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("entityNames")) {
                this.entityNames(model.getEntityNames());
            }
            return this;
        }
    }
}

