/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.DiscoveryLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveryJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="discoveryType")
    private final DiscoveryType discoveryType;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="lifecycleState")
    private final DiscoveryLifecycleState lifecycleState;
    @JsonProperty(value="sensitiveDataModelId")
    private final String sensitiveDataModelId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="schemasForDiscovery")
    private final List<String> schemasForDiscovery;
    @JsonProperty(value="sensitiveTypeIdsForDiscovery")
    private final List<String> sensitiveTypeIdsForDiscovery;
    @JsonProperty(value="isSampleDataCollectionEnabled")
    private final Boolean isSampleDataCollectionEnabled;
    @JsonProperty(value="isAppDefinedRelationDiscoveryEnabled")
    private final Boolean isAppDefinedRelationDiscoveryEnabled;
    @JsonProperty(value="isIncludeAllSchemas")
    private final Boolean isIncludeAllSchemas;
    @JsonProperty(value="isIncludeAllSensitiveTypes")
    private final Boolean isIncludeAllSensitiveTypes;
    @JsonProperty(value="totalSchemasScanned")
    private final Long totalSchemasScanned;
    @JsonProperty(value="totalObjectsScanned")
    private final Long totalObjectsScanned;
    @JsonProperty(value="totalColumnsScanned")
    private final Long totalColumnsScanned;
    @JsonProperty(value="totalNewSensitiveColumns")
    private final Long totalNewSensitiveColumns;
    @JsonProperty(value="totalModifiedSensitiveColumns")
    private final Long totalModifiedSensitiveColumns;
    @JsonProperty(value="totalDeletedSensitiveColumns")
    private final Long totalDeletedSensitiveColumns;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "discoveryType", "displayName", "compartmentId", "timeStarted", "timeFinished", "lifecycleState", "sensitiveDataModelId", "targetId", "schemasForDiscovery", "sensitiveTypeIdsForDiscovery", "isSampleDataCollectionEnabled", "isAppDefinedRelationDiscoveryEnabled", "isIncludeAllSchemas", "isIncludeAllSensitiveTypes", "totalSchemasScanned", "totalObjectsScanned", "totalColumnsScanned", "totalNewSensitiveColumns", "totalModifiedSensitiveColumns", "totalDeletedSensitiveColumns", "freeformTags", "definedTags", "systemTags"})
    public DiscoveryJob(String id, DiscoveryType discoveryType, String displayName, String compartmentId, Date timeStarted, Date timeFinished, DiscoveryLifecycleState lifecycleState, String sensitiveDataModelId, String targetId, List<String> schemasForDiscovery, List<String> sensitiveTypeIdsForDiscovery, Boolean isSampleDataCollectionEnabled, Boolean isAppDefinedRelationDiscoveryEnabled, Boolean isIncludeAllSchemas, Boolean isIncludeAllSensitiveTypes, Long totalSchemasScanned, Long totalObjectsScanned, Long totalColumnsScanned, Long totalNewSensitiveColumns, Long totalModifiedSensitiveColumns, Long totalDeletedSensitiveColumns, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.discoveryType = discoveryType;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.lifecycleState = lifecycleState;
        this.sensitiveDataModelId = sensitiveDataModelId;
        this.targetId = targetId;
        this.schemasForDiscovery = schemasForDiscovery;
        this.sensitiveTypeIdsForDiscovery = sensitiveTypeIdsForDiscovery;
        this.isSampleDataCollectionEnabled = isSampleDataCollectionEnabled;
        this.isAppDefinedRelationDiscoveryEnabled = isAppDefinedRelationDiscoveryEnabled;
        this.isIncludeAllSchemas = isIncludeAllSchemas;
        this.isIncludeAllSensitiveTypes = isIncludeAllSensitiveTypes;
        this.totalSchemasScanned = totalSchemasScanned;
        this.totalObjectsScanned = totalObjectsScanned;
        this.totalColumnsScanned = totalColumnsScanned;
        this.totalNewSensitiveColumns = totalNewSensitiveColumns;
        this.totalModifiedSensitiveColumns = totalModifiedSensitiveColumns;
        this.totalDeletedSensitiveColumns = totalDeletedSensitiveColumns;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public DiscoveryLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public List<String> getSchemasForDiscovery() {
        return this.schemasForDiscovery;
    }

    public List<String> getSensitiveTypeIdsForDiscovery() {
        return this.sensitiveTypeIdsForDiscovery;
    }

    public Boolean getIsSampleDataCollectionEnabled() {
        return this.isSampleDataCollectionEnabled;
    }

    public Boolean getIsAppDefinedRelationDiscoveryEnabled() {
        return this.isAppDefinedRelationDiscoveryEnabled;
    }

    public Boolean getIsIncludeAllSchemas() {
        return this.isIncludeAllSchemas;
    }

    public Boolean getIsIncludeAllSensitiveTypes() {
        return this.isIncludeAllSensitiveTypes;
    }

    public Long getTotalSchemasScanned() {
        return this.totalSchemasScanned;
    }

    public Long getTotalObjectsScanned() {
        return this.totalObjectsScanned;
    }

    public Long getTotalColumnsScanned() {
        return this.totalColumnsScanned;
    }

    public Long getTotalNewSensitiveColumns() {
        return this.totalNewSensitiveColumns;
    }

    public Long getTotalModifiedSensitiveColumns() {
        return this.totalModifiedSensitiveColumns;
    }

    public Long getTotalDeletedSensitiveColumns() {
        return this.totalDeletedSensitiveColumns;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveryJob(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", discoveryType=").append(String.valueOf((Object)this.discoveryType));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", schemasForDiscovery=").append(String.valueOf(this.schemasForDiscovery));
        sb.append(", sensitiveTypeIdsForDiscovery=").append(String.valueOf(this.sensitiveTypeIdsForDiscovery));
        sb.append(", isSampleDataCollectionEnabled=").append(String.valueOf(this.isSampleDataCollectionEnabled));
        sb.append(", isAppDefinedRelationDiscoveryEnabled=").append(String.valueOf(this.isAppDefinedRelationDiscoveryEnabled));
        sb.append(", isIncludeAllSchemas=").append(String.valueOf(this.isIncludeAllSchemas));
        sb.append(", isIncludeAllSensitiveTypes=").append(String.valueOf(this.isIncludeAllSensitiveTypes));
        sb.append(", totalSchemasScanned=").append(String.valueOf(this.totalSchemasScanned));
        sb.append(", totalObjectsScanned=").append(String.valueOf(this.totalObjectsScanned));
        sb.append(", totalColumnsScanned=").append(String.valueOf(this.totalColumnsScanned));
        sb.append(", totalNewSensitiveColumns=").append(String.valueOf(this.totalNewSensitiveColumns));
        sb.append(", totalModifiedSensitiveColumns=").append(String.valueOf(this.totalModifiedSensitiveColumns));
        sb.append(", totalDeletedSensitiveColumns=").append(String.valueOf(this.totalDeletedSensitiveColumns));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveryJob)) {
            return false;
        }
        DiscoveryJob other = (DiscoveryJob)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.discoveryType, (Object)other.discoveryType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.schemasForDiscovery, other.schemasForDiscovery) && Objects.equals(this.sensitiveTypeIdsForDiscovery, other.sensitiveTypeIdsForDiscovery) && Objects.equals(this.isSampleDataCollectionEnabled, other.isSampleDataCollectionEnabled) && Objects.equals(this.isAppDefinedRelationDiscoveryEnabled, other.isAppDefinedRelationDiscoveryEnabled) && Objects.equals(this.isIncludeAllSchemas, other.isIncludeAllSchemas) && Objects.equals(this.isIncludeAllSensitiveTypes, other.isIncludeAllSensitiveTypes) && Objects.equals(this.totalSchemasScanned, other.totalSchemasScanned) && Objects.equals(this.totalObjectsScanned, other.totalObjectsScanned) && Objects.equals(this.totalColumnsScanned, other.totalColumnsScanned) && Objects.equals(this.totalNewSensitiveColumns, other.totalNewSensitiveColumns) && Objects.equals(this.totalModifiedSensitiveColumns, other.totalModifiedSensitiveColumns) && Objects.equals(this.totalDeletedSensitiveColumns, other.totalDeletedSensitiveColumns) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.schemasForDiscovery == null ? 43 : this.schemasForDiscovery.hashCode());
        result = result * 59 + (this.sensitiveTypeIdsForDiscovery == null ? 43 : this.sensitiveTypeIdsForDiscovery.hashCode());
        result = result * 59 + (this.isSampleDataCollectionEnabled == null ? 43 : this.isSampleDataCollectionEnabled.hashCode());
        result = result * 59 + (this.isAppDefinedRelationDiscoveryEnabled == null ? 43 : this.isAppDefinedRelationDiscoveryEnabled.hashCode());
        result = result * 59 + (this.isIncludeAllSchemas == null ? 43 : this.isIncludeAllSchemas.hashCode());
        result = result * 59 + (this.isIncludeAllSensitiveTypes == null ? 43 : this.isIncludeAllSensitiveTypes.hashCode());
        result = result * 59 + (this.totalSchemasScanned == null ? 43 : this.totalSchemasScanned.hashCode());
        result = result * 59 + (this.totalObjectsScanned == null ? 43 : this.totalObjectsScanned.hashCode());
        result = result * 59 + (this.totalColumnsScanned == null ? 43 : this.totalColumnsScanned.hashCode());
        result = result * 59 + (this.totalNewSensitiveColumns == null ? 43 : this.totalNewSensitiveColumns.hashCode());
        result = result * 59 + (this.totalModifiedSensitiveColumns == null ? 43 : this.totalModifiedSensitiveColumns.hashCode());
        result = result * 59 + (this.totalDeletedSensitiveColumns == null ? 43 : this.totalDeletedSensitiveColumns.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DiscoveryType implements BmcEnum
    {
        All("ALL"),
        New("NEW"),
        Modified("MODIFIED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiscoveryType> map;

        private DiscoveryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiscoveryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiscoveryType.class);
            map = new HashMap<String, DiscoveryType>();
            for (DiscoveryType v : DiscoveryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="discoveryType")
        private DiscoveryType discoveryType;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="lifecycleState")
        private DiscoveryLifecycleState lifecycleState;
        @JsonProperty(value="sensitiveDataModelId")
        private String sensitiveDataModelId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="schemasForDiscovery")
        private List<String> schemasForDiscovery;
        @JsonProperty(value="sensitiveTypeIdsForDiscovery")
        private List<String> sensitiveTypeIdsForDiscovery;
        @JsonProperty(value="isSampleDataCollectionEnabled")
        private Boolean isSampleDataCollectionEnabled;
        @JsonProperty(value="isAppDefinedRelationDiscoveryEnabled")
        private Boolean isAppDefinedRelationDiscoveryEnabled;
        @JsonProperty(value="isIncludeAllSchemas")
        private Boolean isIncludeAllSchemas;
        @JsonProperty(value="isIncludeAllSensitiveTypes")
        private Boolean isIncludeAllSensitiveTypes;
        @JsonProperty(value="totalSchemasScanned")
        private Long totalSchemasScanned;
        @JsonProperty(value="totalObjectsScanned")
        private Long totalObjectsScanned;
        @JsonProperty(value="totalColumnsScanned")
        private Long totalColumnsScanned;
        @JsonProperty(value="totalNewSensitiveColumns")
        private Long totalNewSensitiveColumns;
        @JsonProperty(value="totalModifiedSensitiveColumns")
        private Long totalModifiedSensitiveColumns;
        @JsonProperty(value="totalDeletedSensitiveColumns")
        private Long totalDeletedSensitiveColumns;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            this.__explicitlySet__.add("discoveryType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder lifecycleState(DiscoveryLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            this.__explicitlySet__.add("sensitiveDataModelId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder schemasForDiscovery(List<String> schemasForDiscovery) {
            this.schemasForDiscovery = schemasForDiscovery;
            this.__explicitlySet__.add("schemasForDiscovery");
            return this;
        }

        public Builder sensitiveTypeIdsForDiscovery(List<String> sensitiveTypeIdsForDiscovery) {
            this.sensitiveTypeIdsForDiscovery = sensitiveTypeIdsForDiscovery;
            this.__explicitlySet__.add("sensitiveTypeIdsForDiscovery");
            return this;
        }

        public Builder isSampleDataCollectionEnabled(Boolean isSampleDataCollectionEnabled) {
            this.isSampleDataCollectionEnabled = isSampleDataCollectionEnabled;
            this.__explicitlySet__.add("isSampleDataCollectionEnabled");
            return this;
        }

        public Builder isAppDefinedRelationDiscoveryEnabled(Boolean isAppDefinedRelationDiscoveryEnabled) {
            this.isAppDefinedRelationDiscoveryEnabled = isAppDefinedRelationDiscoveryEnabled;
            this.__explicitlySet__.add("isAppDefinedRelationDiscoveryEnabled");
            return this;
        }

        public Builder isIncludeAllSchemas(Boolean isIncludeAllSchemas) {
            this.isIncludeAllSchemas = isIncludeAllSchemas;
            this.__explicitlySet__.add("isIncludeAllSchemas");
            return this;
        }

        public Builder isIncludeAllSensitiveTypes(Boolean isIncludeAllSensitiveTypes) {
            this.isIncludeAllSensitiveTypes = isIncludeAllSensitiveTypes;
            this.__explicitlySet__.add("isIncludeAllSensitiveTypes");
            return this;
        }

        public Builder totalSchemasScanned(Long totalSchemasScanned) {
            this.totalSchemasScanned = totalSchemasScanned;
            this.__explicitlySet__.add("totalSchemasScanned");
            return this;
        }

        public Builder totalObjectsScanned(Long totalObjectsScanned) {
            this.totalObjectsScanned = totalObjectsScanned;
            this.__explicitlySet__.add("totalObjectsScanned");
            return this;
        }

        public Builder totalColumnsScanned(Long totalColumnsScanned) {
            this.totalColumnsScanned = totalColumnsScanned;
            this.__explicitlySet__.add("totalColumnsScanned");
            return this;
        }

        public Builder totalNewSensitiveColumns(Long totalNewSensitiveColumns) {
            this.totalNewSensitiveColumns = totalNewSensitiveColumns;
            this.__explicitlySet__.add("totalNewSensitiveColumns");
            return this;
        }

        public Builder totalModifiedSensitiveColumns(Long totalModifiedSensitiveColumns) {
            this.totalModifiedSensitiveColumns = totalModifiedSensitiveColumns;
            this.__explicitlySet__.add("totalModifiedSensitiveColumns");
            return this;
        }

        public Builder totalDeletedSensitiveColumns(Long totalDeletedSensitiveColumns) {
            this.totalDeletedSensitiveColumns = totalDeletedSensitiveColumns;
            this.__explicitlySet__.add("totalDeletedSensitiveColumns");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public DiscoveryJob build() {
            DiscoveryJob model = new DiscoveryJob(this.id, this.discoveryType, this.displayName, this.compartmentId, this.timeStarted, this.timeFinished, this.lifecycleState, this.sensitiveDataModelId, this.targetId, this.schemasForDiscovery, this.sensitiveTypeIdsForDiscovery, this.isSampleDataCollectionEnabled, this.isAppDefinedRelationDiscoveryEnabled, this.isIncludeAllSchemas, this.isIncludeAllSensitiveTypes, this.totalSchemasScanned, this.totalObjectsScanned, this.totalColumnsScanned, this.totalNewSensitiveColumns, this.totalModifiedSensitiveColumns, this.totalDeletedSensitiveColumns, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveryJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("discoveryType")) {
                this.discoveryType(model.getDiscoveryType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("sensitiveDataModelId")) {
                this.sensitiveDataModelId(model.getSensitiveDataModelId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("schemasForDiscovery")) {
                this.schemasForDiscovery(model.getSchemasForDiscovery());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeIdsForDiscovery")) {
                this.sensitiveTypeIdsForDiscovery(model.getSensitiveTypeIdsForDiscovery());
            }
            if (model.wasPropertyExplicitlySet("isSampleDataCollectionEnabled")) {
                this.isSampleDataCollectionEnabled(model.getIsSampleDataCollectionEnabled());
            }
            if (model.wasPropertyExplicitlySet("isAppDefinedRelationDiscoveryEnabled")) {
                this.isAppDefinedRelationDiscoveryEnabled(model.getIsAppDefinedRelationDiscoveryEnabled());
            }
            if (model.wasPropertyExplicitlySet("isIncludeAllSchemas")) {
                this.isIncludeAllSchemas(model.getIsIncludeAllSchemas());
            }
            if (model.wasPropertyExplicitlySet("isIncludeAllSensitiveTypes")) {
                this.isIncludeAllSensitiveTypes(model.getIsIncludeAllSensitiveTypes());
            }
            if (model.wasPropertyExplicitlySet("totalSchemasScanned")) {
                this.totalSchemasScanned(model.getTotalSchemasScanned());
            }
            if (model.wasPropertyExplicitlySet("totalObjectsScanned")) {
                this.totalObjectsScanned(model.getTotalObjectsScanned());
            }
            if (model.wasPropertyExplicitlySet("totalColumnsScanned")) {
                this.totalColumnsScanned(model.getTotalColumnsScanned());
            }
            if (model.wasPropertyExplicitlySet("totalNewSensitiveColumns")) {
                this.totalNewSensitiveColumns(model.getTotalNewSensitiveColumns());
            }
            if (model.wasPropertyExplicitlySet("totalModifiedSensitiveColumns")) {
                this.totalModifiedSensitiveColumns(model.getTotalModifiedSensitiveColumns());
            }
            if (model.wasPropertyExplicitlySet("totalDeletedSensitiveColumns")) {
                this.totalDeletedSensitiveColumns(model.getTotalDeletedSensitiveColumns());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

