/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.DatabaseDetails;
import com.oracle.bmc.datasafe.model.InfrastructureType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseType")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseCloudServiceDetails
extends DatabaseDetails {
    @JsonProperty(value="vmClusterId")
    private final String vmClusterId;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="listenerPort")
    private final Integer listenerPort;
    @JsonProperty(value="serviceName")
    private final String serviceName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseCloudServiceDetails(InfrastructureType infrastructureType, String vmClusterId, String dbSystemId, Integer listenerPort, String serviceName) {
        super(infrastructureType);
        this.vmClusterId = vmClusterId;
        this.dbSystemId = dbSystemId;
        this.listenerPort = listenerPort;
        this.serviceName = serviceName;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public Integer getListenerPort() {
        return this.listenerPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseCloudServiceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseCloudServiceDetails)) {
            return false;
        }
        DatabaseCloudServiceDetails other = (DatabaseCloudServiceDetails)((Object)o);
        return Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals(this.serviceName, other.serviceName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="infrastructureType")
        private InfrastructureType infrastructureType;
        @JsonProperty(value="vmClusterId")
        private String vmClusterId;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="listenerPort")
        private Integer listenerPort;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder infrastructureType(InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            this.__explicitlySet__.add("infrastructureType");
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            this.__explicitlySet__.add("vmClusterId");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public DatabaseCloudServiceDetails build() {
            DatabaseCloudServiceDetails model = new DatabaseCloudServiceDetails(this.infrastructureType, this.vmClusterId, this.dbSystemId, this.listenerPort, this.serviceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseCloudServiceDetails model) {
            if (model.wasPropertyExplicitlySet("infrastructureType")) {
                this.infrastructureType(model.getInfrastructureType());
            }
            if (model.wasPropertyExplicitlySet("vmClusterId")) {
                this.vmClusterId(model.getVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            return this;
        }
    }
}

