/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AuditTrailLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuditTrailDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="location")
    private final String location;
    @JsonProperty(value="lifecycleState")
    private final AuditTrailLifecycleState lifecycleState;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="targetId")
    private final String targetId;

    @Deprecated
    @ConstructorProperties(value={"location", "lifecycleState", "status", "targetId"})
    public AuditTrailDimensions(String location, AuditTrailLifecycleState lifecycleState, String status, String targetId) {
        this.location = location;
        this.lifecycleState = lifecycleState;
        this.status = status;
        this.targetId = targetId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLocation() {
        return this.location;
    }

    public AuditTrailLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditTrailDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("location=").append(String.valueOf(this.location));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditTrailDimensions)) {
            return false;
        }
        AuditTrailDimensions other = (AuditTrailDimensions)((Object)o);
        return Objects.equals(this.location, other.location) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.status, other.status) && Objects.equals(this.targetId, other.targetId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="location")
        private String location;
        @JsonProperty(value="lifecycleState")
        private AuditTrailLifecycleState lifecycleState;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder location(String location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder lifecycleState(AuditTrailLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public AuditTrailDimensions build() {
            AuditTrailDimensions model = new AuditTrailDimensions(this.location, this.lifecycleState, this.status, this.targetId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuditTrailDimensions model) {
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            return this;
        }
    }
}

